<?php

namespace Database\Factories;

use App\Models\Asset;
use App\Models\Chromebook;
use App\Models\MakeAndModel;
use App\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class ChromebookFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {

        $chromebooks = [
            'AOpen Chromebox Commercial 2',
            'ASUS Chromebook Flip C436FA',
            'AOpen Chromebox Commercial',
            'AOpen Chromebox Mini',
            'Google Pixelbook',
            'AOpen Chromebox Mini',
            'Samsung Galaxy Chromebook',
            'Acer Chromebook Spin 513, CP513-1H/1HL, R841T/LT',
            'Samsung Galaxy Chromebook 2',
            'ASUS Chromebook Flip CX5 (CX5400)',
            'ASUS Chromebox 4',
            'Google Pixelbook Go'
        ];

        $status = $this->faker->randomElement(array(1, 0));

        // Retrieve the existing array from the session or initialize a new empty array
        $oldSerials = session()->get('chromesession', []);

        $asset = $this->faker->randomElement([0, 0, Asset::whereNotIn('serial_no', $oldSerials)
            ->whereHas('assetType', fn($query) => $query->whereIn('slug', ['laptop', 'desktop', 'mobile_phone', 'tablet']))
            ->whereHas('makeAndModel', function ($query) {
                $query->where('name', 'like', '%Chromebook%')->orWhere('name', 'like', '%Google%');
            })
            ->inRandomOrder()->distinct()->first(), 0]);

        $serialNo = $asset ? $asset->serial_no : $this->faker->unique()->regexify('[A-Z]{4}[0-9]{4}');

        $oldSerials[] = $serialNo;
        session()->put('chromesession', $oldSerials);

        $user = $this->faker->randomElement([0, 0, User::inRandomOrder()->first(), 0]);

        $userId = $user ? $user->id : 0;



        return [
            'user_id' => $userId,
            'email' => $user ? $user->email : $this->faker->unique()->safeEmail,
            'serial_no' => $serialNo,
            'model' => $this->faker->randomElement($chromebooks),

            'mac_address' => $this->faker->macAddress(),
            'asset_id' => $asset ? $asset->id : 0,
            'device_id' => $this->faker->ipv4(),
            'status' => $status,

            'last_sync' => parse_datetime_from_db_datetime($this->faker->date() . ' ' . $this->faker->time()),
            'last_enrollment_time' => parse_datetime_from_db_datetime($this->faker->date() . ' ' . $this->faker->time()),
            'host_name' => $this->faker->domainWord(),
        ];
    }
}
