<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class CarrierFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $name = $this->faker->randomElement(['AT&T', 'Verizon', 'Sprint', 'T-Mobile', 'Other']);
        $slug = str_slug($name, '-');
        return [
            'name' => $name,
            'slug' => $slug,
        ];
    }
}
