<?php

namespace Database\Factories;

use App\Models\AssetStatus;
use App\Models\AssetType;
use App\Models\Carrier;
use App\Models\Location;
use App\Models\MakeAndModel;
use App\Models\TechnicalSpecs;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class AssetFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $assetType = AssetType::has('makeAndModel.technicalSpecs')->inRandomOrder()->distinct()->first();
        $makeAndModelId = MakeAndModel::getMakeModelFromAssetTypes([$assetType->id])->has('technicalSpecs')->inRandomOrder()->distinct()->first()->id;
        $technicalSpecId = TechnicalSpecs::getTechnicalSpecs($makeAndModelId)->inRandomOrder()->distinct()->first()->id;
        $created_at = $this->faker->dateTimeBetween($startDate = '-3 years', $endDate = 'now', $timezone = null);
        $assetStatusId = AssetStatus::getNameFromSlug('brand_new')->first()->id;
        return [
            // 'location_id' => Location::warehouses()->inRandomOrder()->distinct()->first()->id,
            'location_id' => null,
            'po_id' => str_random(10),
            'asset_type_id' => 0,
            'make_and_model_id' => 0,
            'technical_spec_id' => 0,
            'asset_tag' => $this->faker->regexify('[A-Z]{5}[0-4]{3}'),
            'serial_no' => $this->faker->regexify('[A-Z]{5}[0-4]{3}'),
            'asset_status_id' => $assetStatusId,
            'ticket_no' => random_int(9999, 99999999),
            'carrier_id' => in_array($assetType->slug, ['mobile_phone', 'mobile_phone_number']) ? Carrier::inRandomOrder()->first()->id : null,
            'imei' => in_array($assetType->slug, ['mobile_phone', 'mobile_phone_number']) ? str_random(10) : null,
            'lease_start_date' => in_array($assetType->id, AssetType::leased()->pluck('id')->toArray()) ? parse_date_from_db_datetime(Carbon::now()) : null,
            'lease_end_date' => in_array($assetType->id, AssetType::leased()->pluck('id')->toArray()) ? parse_date_from_db_datetime(Carbon::now()->addYears(config('date.period.leased'))) : null,
            'created_at' => $created_at,
            'updated_at' => $created_at,
            // 'part_no'  => $this->faker->randomElement(['SHIGLD-744', 'SHIGLN-756', 'SHIJLD-789', 'SHIGLN-147', 'SHIGLD-503', 'SHIGLD-M04', 'SHIGLD-G45', 'SHIGLK-1H5', 'SHIALD-001', 'SHIALN-002', 'SHIJLD-010', 'SHIALN-009', 'SHIALD-003', 'SHIALD-004', 'SHIALD-045', 'SHIALK-105']),
        ];
    }
}
