<?php

namespace Database\Factories;

use App\Models\AirWatch;
use App\Models\Asset;
use App\Models\Carrier;
use App\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;

class AirWatchFactory extends Factory
{
    public $oldSerials = [];
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        // Define an array of possible CPU types and device models

        $models = [
            ['model' => 'MacBook Air', 'cpu' => 'Apple M1', 'year' => 2020, 'type' => 'laptop'],
            ['model' => 'MacBook Pro', 'cpu' => 'Intel Core i5/i7/i9 or Apple M1', 'year' => 2020, 'type' => 'laptop'],
            ['model' => 'iMac', 'cpu' => 'Intel Core i5/i7 or Apple M1', 'year' => 2021, 'type' => 'desktop'],
            ['model' => 'MacBook', 'cpu' => 'Intel Core m3/m5/m7 or Intel Core i5/i7', 'year' => 2017, 'type' => 'laptop'],
            ['model' => 'MacBook Pro with Touch Bar', 'cpu' => 'Intel Core i5/i7/i9 or Apple M1', 'year' => 2020, 'type' => 'laptop'],
            ['model' => 'MacBook Pro without Touch Bar', 'cpu' => 'Intel Core i5/i7', 'year' => 2017, 'type' => 'laptop'],
            ['model' => 'MacBook Pro 16-inch', 'cpu' => 'Intel Core i7/i9', 'year' => 2019, 'type' => 'laptop'],
            ['model' => 'MacBook Air M1', 'cpu' => 'Apple M1', 'year' => 2020, 'type' => 'laptop'],
            ['model' => 'MacBook Pro M1', 'cpu' => 'Apple M1', 'year' => 2020, 'type' => 'laptop'],
            ['model' => 'iMac Pro', 'cpu' => 'Intel Xeon W', 'year' => 2017, 'type' => 'desktop'],
            ['model' => 'Mac mini', 'cpu' => 'Apple M1 or Intel Core i3/i5/i7', 'year' => 2020, 'type' => 'desktop'],
            ['model' => 'Mac Pro', 'cpu' => 'Intel Xeon W', 'year' => 2019, 'type' => 'desktop'],
            // ['model' => 'Samsung Galaxy S21', 'cpu' => 'Qualcomm Snapdragon 888', 'year' => 2021, 'type' => 'mobile_phone'],
            // ['model' => 'Google Pixel 5', 'cpu' => 'Qualcomm Snapdragon 765G', 'year' => 2020, 'type' => 'mobile_phone'],
            ['model' => 'iPhone 12', 'cpu' => 'Apple A14 Bionic', 'year' => 2020, 'type' => 'mobile_phone'],
            ['model' => 'iPhone SE (2020)', 'cpu' => 'Apple A13 Bionic', 'year' => 2020, 'type' => 'mobile_phone'],
            ['model' => 'iPhone 11 Pro', 'cpu' => 'Apple A13 Bionic', 'year' => 2019, 'type' => 'mobile_phone'],
            ['model' => 'iPhone XS', 'cpu' => 'Apple A12 Bionic', 'year' => 2018, 'type' => 'mobile_phone'],
            ['model' => 'iPhone XR', 'cpu' => 'Apple A12 Bionic', 'year' => 2018, 'type' => 'mobile_phone'],
            ['model' => 'iPhone X', 'cpu' => 'Apple A11 Bionic', 'year' => 2017, 'type' => 'mobile_phone'],
            ['model' => 'iPhone 8', 'cpu' => 'Apple A11 Bionic', 'year' => 2017, 'type' => 'mobile_phone'],
            ['model' => 'AirWatch Phone 1', 'cpu' => '', 'phone_number' => '123-456-7890', 'year' => 2021, 'type' => 'mobile_phone'],
            ['model' => 'AirWatch Phone 2', 'cpu' => '', 'phone_number' => '987-654-3210', 'year' => 2021, 'type' => 'mobile_phone'],
            ['model' => 'Mac Pro', 'cpu' => 'Intel Xeon W', 'year' => 2019,  'type' => 'desktop'],
            // ['model' => 'Samsung Galaxy S20', 'cpu' => 'Qualcomm Snapdragon 865', 'year' => 2020, 'phone_number' => '123-456-7890', 'type' => 'mobile_phone'],
            // ['model' => 'Google Pixel 4a', 'cpu' => 'Qualcomm Snapdragon 730G', 'year' => 2020, 'phone_number' => '123-456-7890', 'type' => 'mobile_phone'],
            ['model' => 'iPhone 11', 'cpu' => 'Apple A13 Bionic', 'year' => 2019, 'phone_number' => '123-456-7890', 'type' => 'mobile_phone'],
            ['model' => 'iPhone XS Max', 'cpu' => 'Apple A12 Bionic', 'year' => 2018, 'phone_number' => '123-456-7890', 'type' => 'mobile_phone'],
            ['model' => 'MacBook Air', 'cpu' => 'Apple M1', 'year' => 2020, 'type' => 'laptop'],
            ['model' => 'MacBook Pro', 'cpu' => 'Intel Core i5/i7/i9 or Apple M1', 'year' => 2020, 'type' => 'laptop'],
            ['model' => 'iMac', 'cpu' => 'Intel Core i5/i7 or Apple M1', 'year' => 2021, 'type' => 'desktop'],
            ['model' => 'MacBook', 'cpu' => 'Intel Core m3/m5/m7 or Intel Core i5/i7', 'year' => 2017, 'type' => 'laptop'],
            ['model' => 'MacBook Pro with Touch Bar', 'cpu' => 'Intel Core i5/i7/i9 or Apple M1', 'year' => 2020, 'type' => 'laptop'],
            ['model' => 'MacBook Pro without Touch Bar', 'cpu' => 'Intel Core i5/i7', 'year' => 2017, 'type' => 'laptop'],
            ['model' => 'MacBook Pro 16-inch', 'cpu' => 'Intel Core i7/i9', 'year' => 2019, 'type' => 'laptop'],
            ['model' => 'MacBook Air M1', 'cpu' => 'Apple M1', 'year' => 2020, 'type' => 'laptop'],
            ['model' => 'MacBook Pro M1', 'cpu' => 'Apple M1', 'year' => 2020, 'type' => 'laptop'],
            ['model' => 'iMac Pro', 'cpu' => 'Intel Xeon W', 'year' => 2017, 'type' => 'desktop'],
            ['model' => 'Mac mini', 'cpu' => 'Apple M1 or Intel Core i3/i5/i7', 'year' => 2020, 'type' => 'desktop'],
            ['model' => 'Mac Pro', 'cpu' => 'Intel Xeon W', 'year' => 2019, 'type' => 'desktop'],
            // ['model' => 'Samsung Galaxy S21', 'cpu' => 'Qualcomm Snapdragon 888', 'year' => 2021, 'type' => 'mobile_phone'],
            // ['model' => 'Google Pixel 5', 'cpu' => 'Qualcomm Snapdragon 765G', 'year' => 2020, 'type' => 'mobile_phone'],
            ['model' => 'iPhone 12', 'cpu' => 'Apple A14 Bionic', 'year' => 2020, 'type' => 'mobile_phone'],
            ['model' => 'iPhone SE (2020)', 'cpu' => 'Apple A13 Bionic', 'year' => 2020, 'type' => 'mobile_phone'],
            ['model' => 'iPhone 11 Pro', 'cpu' => 'Apple A13 Bionic', 'year' => 2019, 'type' => 'mobile_phone'],
            ['model' => 'iPhone XS', 'cpu' => 'Apple A12 Bionic', 'year' => 2018, 'type' => 'mobile_phone'],
            ['model' => 'iPhone XR', 'cpu' => 'Apple A12 Bionic', 'year' => 2018, 'type' => 'mobile_phone'],
            ['model' => 'iPhone X', 'cpu' => 'Apple A11 Bionic', 'year' => 2017, 'type' => 'mobile_phone'],
            ['model' => 'iPhone 8', 'cpu' => 'Apple A11 Bionic', 'year' => 2017, 'type' => 'mobile_phone'],
            ['model' => 'iPad Pro 12.9 (2021)', 'cpu' => 'Apple M1', 'year' => 2021, 'type' => 'tablet'],
            ['model' => 'iPad Air (2020)', 'cpu' => 'Apple A14 Bionic', 'year' => 2020, 'type' => 'tablet'],
            // ['model' => 'Samsung Galaxy Tab S7+', 'cpu' => 'Qualcomm Snapdragon 865+', 'year' => 2020, 'type' => 'tablet'],
            // ['model' => 'Google Pixel Slate', 'cpu' => 'Intel Core m3/i5/i7', 'year' => 2018, 'type' => 'tablet'],
        ];


        $times = ['Early', 'Mid', 'Late'];

        $model = $this->faker->randomElement($models);

        $deviceName = $model['model'] . ' "' . $model['cpu'] . '" ' . substr($model['year'], 2, 2) . '" (' . $this->faker->randomElement($times) . ' ' . $model['year'] . ')';
        $ownerShips = ['C', 'S', 'E'];

        $lockdatetime = $this->faker->dateTimeBetween('-2 years', 'now');
        $lockDatetime = $lockdatetime->format('Y-m-d H:i:s');

        $lockedDate = [NULL, NULL, NULL, NULL, NULL, NULL, NULL, $lockDatetime, NULL, NULL, NULL];

        $lastdatetime = $this->faker->dateTimeBetween('-2 years', 'now');
        $lastSeenDatetime = $lastdatetime->format('Y-m-d\TH:i:s.u');

        $phoneNumber = NULL;
        if (isset($model['phone_number'])) {
            $phoneNumber = $this->faker->phoneNumber();
        }


        $imei = $phoneNumber ? $this->faker->numerify('####-####-#####-####') : NULL;

        $carrier = $phoneNumber ? Carrier::inRandomOrder()->first() : '';

        // Retrieve the existing array from the session or initialize a new empty array
        $oldSerials = session()->get('airwatchsession', []);

        $asset = $this->faker->randomElement([0, 0, Asset::whereNotIn('serial_no', $oldSerials)
            ->whereHas('assetType', fn($query) => $query->where('slug', $model['type']))
            ->whereHas('makeAndModel.manufacturer', fn($query) => $query->where('name', 'Apple'))
            ->hasNoDiscoveryAssets()->inRandomOrder()->distinct()->first(), 0]);

        $serialNo = $asset ? $asset->serial_no : $this->faker->unique()->regexify('[A-Z]{4}[0-9]{4}');
        $oldSerials[] = $serialNo;
        session()->put('airwatchsession', $oldSerials);


        $firstName = $this->faker->firstName();
        $lastName = $this->faker->lastName();
        $userName = $firstName . '.' . $lastName;

        $user = $this->faker->randomElement([0, 0, User::inRandomOrder()->first(), 0]);

        $userId = $user ? $user->id : 0;

        // dd($lastSeenDatetime, $lockDatetime);
        return [
            'user_id' => $userId,
            'user_name' => $userName,
            'first_name' => $firstName,
            'last_name' => $lastName,
            'email' => $user ? $user->email : $userName . '@company.com',
            'friendly_name' => $userName . ' - ' . $serialNo,
            'serial_no' => $serialNo,
            'model' => $deviceName,
            'last_seen' => $lastSeenDatetime,
            'ownership' => $this->faker->randomElement($ownerShips),
            'asset_id' => $asset ? $asset->id : 0,
            'locked_date' => $this->faker->randomElement($lockedDate),
            'host_name' => $this->faker->domainWord(),
            'mac_address' => $this->faker->macAddress(),
            'phone_number' => $phoneNumber,
            'imei' => $imei,
            'carrier' => optional($carrier)->name,
            'carrier_id' => optional($carrier)->id
        ];
    }

    private function genenrateSerialNumber()
    {
        $asset = $this->faker->randomElement([0, 0, Asset::whereNotIn('serial_no', $airWatchSerials)
            ->whereHas('assetType', fn($query) => $query->where('slug', $model['type']))
            ->hasNoDiscoveryAssets()->inRandomOrder()->distinct()->first(), 0]);

        $serialNo = $asset ? $asset->serial_no : $this->faker->unique()->regexify('[A-Z]{4}[0-9]{4}');

        return $serialNo;
    }
}
