<?php

namespace Database\Factories;

use App\Models\Location;
use App\Models\MakeAndModel;
use App\Models\TechnicalSpecs;
use Illuminate\Database\Eloquent\Factories\Factory;

class AccessoryFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'location_id' => Location::inRandomOrder()->first()->id,
            'make_and_model_id' => MakeAndModel::inRandomOrder()->first()->id,
            'technical_spec_id' => TechnicalSpecs::inRandomOrder()->first()->id,
            'available_quantity' => random_int(0, 100),
            'weekly_demand' => random_int(0, 50),
            'lead_time' => random_int(0, 10),
            'order_quantity' => random_int(0, 120),
            'purchase_indicator' => random_int(0, 1),
        ];
    }
}
