<?php

return [
	'service' => env('TICKET_SERVICE', 'Jira'), // Taking Jira as default value

	'Jira' => [
		'integration_class' => 'JiraIntegration',
		'newline_character' => '\\n',
		'bold_text_start' => '*',
		'bold_text_end' => '*',
		'html_entity_start' => '',
		'html_entity_end' => '',
		'ticket_title_field' => 'summary',
		'ticket_description_field' => 'description',
	],

	'Zendesk' => [
		'integration_class' => 'ZendeskIntegration',
		'newline_character' => "\n",
		'bold_text_start' => '**',
		'bold_text_end' => '**',
		'html_entity_start' => '',
		'html_entity_end' => '',
		'ticket_title_field' => 'summary',
		'ticket_description_field' => 'description',
	],

	'FreshService' => [
		'integration_class' => 'FreshServiceIntegration',
		'newline_character' => '\n',
		'bold_text_start' => '*',
		'bold_text_end' => '*',
		'html_entity_start' => '',
		'html_entity_end' => '',
		'ticket_title_field' => 'summary',
		'ticket_description_field' => 'description',
	],

	'ServiceNow' => [
		'integration_class' => 'ServiceNowIntegration',
		'newline_character' => '<br>',
		'bold_text_start' => '<b>',
		'bold_text_end' => '</b>',
		'html_entity_start' => '[code]',
		'html_entity_end' => '[/code]',
		'ticket_title_field' => 'summary',
		'ticket_description_field' => 'description',
	]
];
