<?php

use Carbon\Carbon;

return [
    'license_types' => [
        'subscription' => 'Subscription',
        'perpetual' => 'Perpetual',
    ],
    'billing_cycles' => [
        'monthly' => 'Monthly',
        'annual' => 'Annual',
    ],
    'subscription_length' => [
        '1 month' => '1 Month',
        '3 months' => '3 Months',
        '6 months' => '6 Months',
        '1 year' => '1 Year'
    ],
    'licence_status' => [
        '1' => 'Active',
        '0' => 'Inactive',
    ],
    'auto_renewal' => [
        'yes' => 'Yes',
        'no' => 'No',
        'n/a' => 'N/A',
    ],
    'softwareAssetData' => [
        'software_license_category_id'               => 'Category',
        'software_license_manufacturer_id'           => 'Manufacturer',
        'vendor_id'                                  => 'Vendor',
        'name'                                       => 'Product Name',
        'po_number'                                  => 'PO #',
        'order_number'                               => 'Order #',
        'type'                                       => 'Type',
        'license_type'                               => 'License Type',
        'software_license_subscription_id'           => 'Subscription Length',
        'subscription_expiration'                    => 'Subscription Expiration Date',
        'auto_renewal'                               => 'Auto Renewal',
        'license_key_type'                           => 'License Key (type)',
        'key_usage_type'                             => 'Key Usage Type',
        'license_key'                                => 'License Keys',
        'users_allowed_for_key'                      => '# of Users Allowed',
        'start_date'                                 => 'Contract Start Date(mm/dd/yyyy)',
        'billing_cycle'                              => 'Billing Cycle',
        'payment_method_id'                          => 'Payment Method',
        'cost'                                       => 'Cost',
        'licenses_purchased'                         => 'Licenses Purchased',
        'notes'                                      => 'Notes',
        'status'                                     => 'Status',
    ],
    'types' => [
        'saas_cloud' => 'Saas / Cloud',
        'on_premise' => 'On-Premise',
    ],

    'license_key_types' => [
        'no_license' => 'No License Key Required',
        'single_license' => 'Single / Concurrent License',
        'user_license' => 'User License',
    ],

    'key_usage_types' => [
        'n/a' => 'N/A',
        'unlimited_usage' => 'Unlimited Usage',
        'limited_usage' => 'Limited Users',
        'unique_usage' => 'Unique Key Per User',
    ],

    'users_allowed' => [
        'unlimited_usage' => 'U',
        'unique_usage' => '1',
    ],

    'license_key_length' => [6, 20],
    'notification_period' => [
        Carbon::now()->addDays(7)->format('Y-m-d'),
        Carbon::now()->addDays(15)->format('Y-m-d'),
        Carbon::now()->addDays(30)->format('Y-m-d'),
        Carbon::now()->addDays(60)->format('Y-m-d'),
        Carbon::now()->addDays(90)->format('Y-m-d')
    ],
    'imported_softwares' => ['Dropbox', 'Zoom', 'Slack'],
    'imported_user_statuses' => [
        'Dropbox' => ['active','inactive','invited','suspended'],
        'Zoom' => ['active'],
        'Slack' => [],
    ],
    'imported_user_roles' => [
        'Dropbox' => ['team_admin','member_only'],
        'Zoom' => ['owner', 'admin', 'member'],
        'Slack' => [],
    ],
    'imported_softwares_data' =>[
        'dropbox' => [
            'callback_url' => 'dropbox/callback',
            'scopes' => ['team_info.read','members.read'],
        ],
        'slack' => [
            'callback_url' => 'slack/callback',
            'scopes' => 'users:read,users.profile:read',
        ]
    ]

];
