<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Stripe, Mailgun, SparkPost and others. This file provides a sane
    | default location for this type of information, allowing packages
    | to have a conventional place to find your various credentials.
    |
    */

    'mailgun' => [
        'domain' => env('MAILGUN_DOMAIN'),
        'secret' => env('MAILGUN_SECRET'),
    ],

    'ses' => [
        'key' => env('SES_KEY'),
        'secret' => env('SES_SECRET'),
        'region' => env('SES_REGION', 'us-east-2'),
    ],

    'sparkpost' => [
        'secret' => env('SPARKPOST_SECRET'),
    ],

    'stripe' => [
        'model' => App\User::class,
        'key' => env('STRIPE_KEY'),
        'secret' => env('STRIPE_SECRET'),
    ],

    'intune' => [
        'base_url' => 'https://login.microsoftonline.com',
        'scopes' => 'openid profile offline_access DeviceManagementManagedDevices.Read.All',
    ],
    'okta' => [
        'client_id' => env('OKTA_CLIENT_ID'),
        'client_secret' => env('OKTA_CLIENT_SECRET'),
        'redirect' => env('OKTA_REDIRECT_URI'),
        'base_url' => env('OKTA_BASE_URL')
    ],
    'dropbox' => [
        'base_url' => 'https://api.dropboxapi.com',
        'api_version' => 2,
        'authorize_url' => 'https://www.dropbox.com/oauth2/authorize',
    ],
    'asn_shi' => [
        'base_url'  => 'https://api.shi.com/',
        'token_url' => "https://accounts.shi.com/connect/token",
        'scope'     => "CustomerAPI.Public CustomerAPI.OrderQuery",
    ],
    'zoom' => [
        'base_url' => 'https://api.zoom.us',
        'api_version' => 'v2',
    ],
    'slack' => [
        'base_url' => 'https://slack.com/api',
        'api_version' => '',
        'authorize_url' => 'https://slack.com/oauth/v2/authorize',
        'token_url' => 'https://slack.com/api/oauth.v2.access',
        'channel_list_url' => 'https://slack.com/api/conversations.list',
        'channel_details_url' => 'https://slack.com/api/conversations.info',
        'bot_scopes' => 'users:read,users:read.email,channels:read,chat:write,chat:write.public,groups:read',
        'user_scopes' => '',
        'post_message_url' => 'https://slack.com/api/chat.postMessage',
        'add_to_conversation_url' => 'https://slack.com/api/conversations.invite',
        'search_user_api_url' => 'https://slack.com/api/users.lookupByEmail'
    ],
    'crowdstrike' => [
        'base_url' => 'https://api.us-2.crowdstrike.com',
        'user_agent' => 'teqtivity-cs/1.0',
    ],
    'google_workspace' => [
        'google_directory' => [
            "slug"  => "google_directory",
            "alg"   => "RS256",   //JWT header algorithm
            "scope" => "https://www.googleapis.com/auth/admin.directory.user.readonly",
        ],
        'gsuite' => [
            "slug"  => "gsuite",
            "alg"   => "RS256",   //JWT header algorithm
            "scope" => "https://www.googleapis.com/auth/admin.directory.resource.calendar.readonly",
        ],
        'chromebook' => [
            "slug"  => "chromebook",
            "alg"   => "RS256",   //JWT header algorithm
            "scope" => "https://www.googleapis.com/auth/admin.directory.device.chromeos.readonly",
        ],
    ],
    'active_directory' => [
        'base_url' => 'https://login.microsoftonline.com',
        'scopes' => 'openid profile offline_access User.Read.All Directory.Read.All',
    ],
    'zoom_hardware' => [
        'base_url' => 'https://api.zoom.us',
        'api_version' => 'v2',
        'authorize_url' => 'https://zoom.us/oauth/authorize',
        'token_url' => 'https://zoom.us/oauth/token',
    ]
];
