<?php

return [
	// Computer by Age report options
	'computer_by_age_options' => [
		'age_filter_options' => [
			'_1' => 'Less than 1 year',
			'1_2' => '1 to 2 years',
			'2_3' => '2 to 3 years',
			'3_' => 'More than 3 years'
		],
	],
	'on_hand_asset_age_options' => [
		'age_filter_options' => [
			'_1' => 'Less than 1 year',
			'1_2' => '1 to 2 years',
			'2_3' => '2 to 3 years',
			'3_' => 'More than 3 years'
		],
	],

	'upcoming_refresh' => [
		'age_filter_options' => [
			'2.5_3' => '2.5 to 3 years',
			'3_4' => '3 to 4 years',
			'4_5' => '4 to 5 years',
			'5_6' => '5 to 6 years',
			'6_' => 'More than 6 years'
		],
		'label' => "Upcoming Refresh",
		'link' => '/report/upcoming-refresh',
		'include_asset_types' => ['laptop', 'desktop', 'computer'],
	],

	'assets_created' => [
		'label' => 'Assets Created',
		'link'  => '/report/assets-created'
	],
	'cycle_count' => [
		'label' => 'Cycle Count',
		'link'  => '/inventory-control/cycle-count'
	],
	'brand_new_to_assigned' => [
		'label' => 'Brand New to Assigned',
		'link'  => '/report/brand_new_to_assigned'
	],
	'brand_new_assigned_to_contractor' => [
		'label' => 'Brand New Assigned to Contractor',
		'link'  => '/report/brandnew-assigned-to-contractor'
	],
	'damaged_trends' => [
		'label' => 'Damaged Trends',
		'link'  => '/report/damaged-trends',
		'exclude_asset_types' => ['mobile_phone_number'],
		'laptop_asset_types' => ['laptop'],
	],
	'fleet_age' => [
		'label' => 'Fleet Age',
		'link'  => '/inventory-control/fleet-age'
	],
	'linked_devices' => [
		'label' => 'Linked Devices',
		'link'  => '/report/linked-devices'
	],
	// 'on_hand_asset_age' => [
	// 	'label' => 'On Hand Asset Age',
	// 	'link'  => '/inventory-control/on-hand-asset-age'
	// ],
	'warranty_expiration_date' => [
		'label' => 'Warranty Expiration Date',
		'link'  => '/report/warranty-expiration-date',
		'include_asset_types' => ['computer', 'desktop', 'laptop']
	],
	'os_compliance' => [
		'label' => 'Operating System Compliance',
		'link'  => '/report/os-compliance-report/apple',
		'apple_mobile_include_asset_types' => ['tablet', 'mobile_phone'],
		'apple_exclude_asset_types' => ['tablet', 'mobile_phone'],
	],
	'duplicate_assets' => [
		'label' => 'Duplicate Assets',
		'link'  => '/report/duplicate-assets'
	],
	'assets_by_department' => [
		'label' => 'Assets By Department',
		'link'  => '/report/assets-by-department'
	],
	'asset_type_to_user' => [
		'label' => 'Users to Asset Ratio',
		'link'  => '/inventory-control/asset-type-to-user'
	],
	'active_users_with_no_asset' => [
		'label' => 'Active Users with No Assets Assigned',
		'link'  => '/report/active-users-with-no-asset'
	],
	'depreciation_value' => [
		'label' => 'Depreciation Value',
		'link'  => '/report/depreciation-value'
	],
	'use_tax' => [
		'label' => "Use Tax",
		'link' => '/report/use-tax'
	],
	'assigned_devices' => [
		'label' => "Assigned Devices",
		'link' => 'report/assigned-devices',
		'used_asset_status' => ['assigned', 'loaned', 'installed']
	],
	'reused_devices' => [
		'label' => "Reused Devices",
		'link' => 'report/reused-devices',
		'stock_statuses' => ['brand_new'],
		'used_statuses' => ['assigned', 'loaned', 'installed'],
		'not_reused_statuses' => ['end_of_life', 'end_of_life_data_wiped'],
		'unwanted_statuses' =>  ['end_of_life', 'end_of_life_data_wiped',  'rma_returned', 'stolen_lost']
	],
	'computer_by_age' => [
		'label' => "Computer By Age",
		'link' => 'report/computer-by-age'
	],
	'deployment_report' => [
		'label' => "Computers Deployed",
		'link' => '/report/computers-deployed'
	],
	'assets_assigned_by_month_report' => [
		'label' => "Assets Assigned By Month",
		'link' => '/report/assets-assigned-by-month'
	],
	'average_time_brand_new_report' => [
		'label' => "Average Time Brand New",
		'link' => '/report/average-time-in-brand-new'
	],
	'asset_recovery' => [
		'label' => "Asset Recovery",
		'link' => '/report/asset-recovery'
	],
	'computers' => [
		'label' => "Computers",
		'link' => '/report/computers'
	],
	'computers_by_age' => [
		'label' => "Computers By Age",
		'link' => '/report/computers-by-age'
	],
	'in-stock-computers' => [
		'label' => "In Stock Computers",
		'link' => '/inventory-control/in-stock-computers',
		'include_asset_types' => ['laptop', 'desktop', 'computer'],
		'include_statuses' => ['brand_new', 'used'],
	],
	'available-stock' => [
		'label' => "Available Stock",
		'link' => '/inventory-control/available-stock',
		'include_statuses' => ['brand_new', 'loaned', 'used'],
	],
	'consumption_report' => [
		'label' => 'Consumption Report',
		'link' => '/inventory-control/consumption-report',
		'include_statuses' => ['assigned', 'loaned', 'installed', 'retain_hold'],
		'include_asset_types' => ['laptop', 'desktop', 'mobile_phone', 'tablet'],
		'exclude_prev_statuses' => ['assigned', 'loaned', 'installed', 'retain_hold'],
	],
	'repair_and_recovery' => [
		'include_statuses' => ['used', 'retain_hold'],
	],
	'asset_recovery_value' => [
		'include_statuses' => ['assigned', 'loaned', 'used', 'damaged', 'retain_hold'],
		'include_asset_types' => ['laptop', 'desktop', 'computer', 'mobile_phone', 'tablet'],
	],
	'retrieval_statistics' => [
		'coming_back_statuses' => ['assigned', 'loaned'],
		'unrecoverable_statuses' => ['stolen_lost', 'end_of_life_data_wiped'],
	],
	// Common config for all the reports
	"common_reports" => [
		'exclude_statuses' => ['cdw_in_transit', 'insight_in_transit', 'shi_in_transit', 'connection_in_transit', 'rma_returned', 'end_of_life', 'end_of_life_data_wiped']
	],

];
