<?php

return [
    'type' => [
        'join' => ['asset_types', 'assets.asset_type_id', '=', 'asset_types.id'],
        'order' => ['asset_types.name', '{dir}'],
    ],
    'hardware_standard' => [
        'joins' => [
            ['make_and_models', 'assets.make_and_model_id', '=', 'make_and_models.id'],
            ['manufacturers', 'make_and_models.manufacturer_id', '=', 'manufacturers.id']
        ],
        'order' => [['manufacturers.slug', '{dir}'], ['make_and_models.slug', '{dir}']],
    ],
    'technical_spec' => [
        'join' => ['technical_specs', 'assets.technical_spec_id', '=', 'technical_specs.id'],
        'order' => ['technical_specs.details', '{dir}'],
    ],
    'status' => [
        'join' => ['asset_statuses', 'assets.asset_status_id', '=', 'asset_statuses.id'],
        'order' => ['asset_statuses.name', '{dir}'],
    ],
    'user_location' => [
        'join' => ['locations', 'assets.location_id', '=', 'locations.id'],
        'order' => ['locations.room_name', '{dir}'],
    ],
    'carrier' => [
        'join' => ['carriers', 'assets.carrier_id', '=', 'carriers.id'],
        'order' => ['carriers.name', '{dir}'],
    ],
];
