<?php

return [
    'discovery_tools' => [
        'airwatch' => [
            'table_name' => 'air_watches',
            'last_seen_column' => 'last_seen',
            'user_discrepancy_statuses' => [
                'assigned',
                'loan_or_test',
                'gifted'
            ],
            'assigned_statuses' => [
                'assigned',
                'installed'
            ],
            'not_in_mdm_method' => 'getNotCheckedIn',
            'device_on_hand_checked_in_method' => 'getDevicesOnHandCheckedIn',
            'model_name' => 'AirWatch'
        ],
        'chromebook' => [
            'table_name' => 'chromebooks',
            'last_seen_column' => 'last_sync',
            'user_discrepancy_statuses' => [
                'assigned',
                'loan_or_test',
                'gifted'
            ],
            'assigned_statuses' => [
                'assigned',
                'installed'
            ],
            'not_in_mdm_method' => 'getNotCheckedIn',
            'device_on_hand_checked_in_method' => 'getDevicesOnHandCheckedIn',
            'model_name' => 'Chromebook'
        ],
        'intune' => [
            'table_name' => 'intune_computers',
            'last_seen_column' => 'checkin_date',
            'user_discrepancy_statuses' => [
                'assigned',
                'loaned',
            ],
            'assigned_statuses' => [
                'assigned',
                'loaned'
            ],
            'not_in_mdm_method' => 'getNotManaged',
            'device_on_hand_checked_in_method' => 'getDevicesOnHandCheckedIn',
            'model_name' => 'IntuneComputer'
        ],
        'jamf' => [
            'table_name' => 'jamf_computers',
            'last_seen_column' => 'checkin_date',
            'user_discrepancy_statuses' => [
                'assigned',
                'loan_or_test',
                'gifted'
            ],
            'assigned_statuses' => [
                'assigned',
                'installed'
            ],
            'not_in_mdm_method' => 'getNotManagedDevices',
            'device_on_hand_checked_in_method' => 'getDevicesOnHandCheckedIn',
            'model_name' => 'JamfComputer'
        ],
        'kandji' => [
            'table_name' => 'kandji_devices',
            'last_seen_column' => 'last_checkin',
            'user_discrepancy_statuses' => [
                'assigned',
                'loan_or_test',
                'gifted'
            ],
            'assigned_statuses' => [
                'assigned',
                'installed'
            ],
            'not_in_mdm_method' => 'getNotManaged',
            'device_on_hand_checked_in_method' => 'getDevicesOnHandCheckedIn',
            'model_name' => 'KandjiDevices'
        ],
        'mobile_iron' => [
            'table_name' => 'mobile_irons',
            'last_seen_column' => 'last_checkin',
            'user_discrepancy_statuses' => [
                'assigned',
                'loan_or_test',
                'gifted'
            ],
            'assigned_statuses' => [
                'assigned',
                'installed'
            ],
            'not_in_mdm_method' => 'getNotManaged',
            'device_on_hand_checked_in_method' => 'getDevicesOnHandCheckingIn',
            'model_name' => 'MobileIron'
        ],
    ],

    'method_map' => [
        'end_of_life_wiped_with_no_certificate' => 'getEndOfLifeAssetsWithoutCertificate',
        'end_of_life_wiped_checking_in' => 'getEndOfLifeWipedCheckingIn',
        'lost_or_stolen_no_locked' => 'getLostOrStolenNoLocked',
        'lost_or_stolen_checking_in' => 'getLostOrStolenCheckingIn',
        'legal_hold_not_backed_up' => 'getLegalHoldNotBackedUp',
        'user_discrepancy' => 'getUserDiscrepancy',
        'assigned_device_not_active' => 'getAssignedDeviceNotActive',
        'not_in_mdm' => 'getAssetsNotInMdm',
        'assigned_to_inactive_user' => 'getAssignedToInactiveUser',
        'damaged_longer_than_30_days' => 'getDamagedLongerThanThirtyDays',
        'asset_age_over_3_years' => 'getAssetAgeOverThreeYears',
        'overdue_loaner' => 'getOverdueLoaner',
        'overdue_retain_hold' => 'getOverdueRetainHoldAssets',
        'installed_in_inactive_location' => 'getInstalledInInactiveLocation',
        'missing_po' => 'getMissingPurchaseOrders',
        'missing_vendor' => 'getMissingVendor',
        'missing_purchase_price' => 'getMissingPurchasePrice',
        'warranty_expired' => 'getExpiredWarrantyAssets',
        'device_on_hand_checked_in' => 'getDevicesOnHandCheckedIn',
        'managed_deployed_not_checked_in' => 'getManagedDeployedNotCheckedIn',
    ],

    'top_issue_classes' => [
        'warnings' => 'progress-bar-warning',
        'notices' => 'progress-bar-info',
        'errors' => 'progress-bar-danger'
    ],

    'map_colors' => [
        'all' => '#ff8167',
        'errors' => '#66ff81',
        'warnings' => '#6681ff',
        'notices' => '#ff66fc',
        'end_of_life_wiped_with_no_certificate' => '#96ff80',
        'end_of_life_wiped_checking_in' => '#ff6681',
        'lost_or_stolen_no_locked' => '#66dbff',
        'lost_or_stolen_checking_in' => '#db66ff',
        'user_discrepancy' => '#ffdb66',
        'assigned_device_not_active' => '#66ffdb',
        'not_in_mdm' => '#a266ff',
        'assigned_to_inactive_user' => '#ffa266',
        'damaged_longer_than_30_days' => '#66ffa2',
        'asset_age_over_3_years' => '#ff66a2',
        'overdue_loaner' => '#66a2ff',
        'overdue_retain_hold' => '#a2ff66',
        'installed_in_inactive_location' => '#ff66a0',
        'missing_po' => '#66a0ff',
        'missing_vendor' => '#b0ff80',
        'missing_purchase_price' => '#ffa066',
        'warranty_expired' => '#d25a87',
        'legal_hold_not_backed_up' => '#ff6a33',
        'missing_checkin' => '#3bb16f',
        'missing_checkin_reason' => '#e4b849',
        'missing_checkin_reason_other' => '#e4843f',
        'superceded_by_another_device' => '#7fb1b3',
        'in_use' => '#aed75b',
        'wiped_checking_in' => '#94a2af',
        'device_on_hand_checked_in' => '#cdc88e',
        'managed_deployed_not_checked_in' => '#a0a0a0',
        'not_created_checking_in' => '#2cd9d0',
    ],

    'datatable_columns' => [
        'default' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],
        'assigned_device_not_active' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],
        'installed_in_inactive_location' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],
        'user_discrepancy' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],
        'warranty_expired' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'warranty_end_date' => 'Warranty Expired Date',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],
        'asset_age_over_3_years' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'asset_age' => 'Asset Age',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],

        'damaged_longer_than_30_days' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],

        'overdue_retain_hold' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],

        'assigned_to_inactive_user' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],

        'not_in_mdm' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],

        'end_of_life_wiped_with_no_certificate' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],

        'end_of_life_wiped_checking_in' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],

        'lost_or_stolen_no_locked' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],

        'legal_hold_not_backed_up' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],

        'overdue_loaner' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],

        'overdue_loaner' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],

        'missing_po' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],

        'missing_vendor' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],

        'missing_purchase_price' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],

        'lost_or_stolen_checking_in' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],

        'device_on_hand_checked_in' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],

        'managed_deployed_not_checked_in' => [
            'id' => '#',
            'serial_no' => 'Serial #',
            'asset_tag' => 'Asset Tag',
            'asset_type' => 'Asset Type',
            'hardware_standard' => 'Hardware Standard',
            'tech_specs' => 'Technical Specs',
            'asset_status' => 'Asset Status',
            'user_location' => 'User/Location',
            'last_seen' => 'Last Seen',
            'last_modified_date' => 'Last Modified Date',
            'last_modified_by' => 'Last Modified By',
        ],
    ],
];
