<?php

return [

	'select' => [

		'asset_type' 			=> [
			'display_name'  => 'Asset Type',
			'db_name' 		=> 'asset_type_id',
			'model' 		=> '\App\Models\AssetType',
			'value_name'	=> 'name',
			'value_id'		=> 'id',

		],
		'manufacturer' 		=> [
			'display_name'  => 'Manufacturer',
			'db_name' 		=> 'manufacturer_id',
			'model' 		=> '\App\Models\Manufacturer',
			'value_name'	=> 'name',
			'value_id'		=> 'id',
		],
		'make_and_model' 		=> [
			'display_name'  => 'Hardware Standard',
			'db_name' 		=> 'make_and_model_id',
			'model' 		=> '\App\Models\MakeAndModel',
			'value_name'	=> 'makeModelName',
			'value_id'		=> 'id',
		],
		'technical_spec' 		=> [
			'display_name'  => 'Technical Specs',
			'db_name'		=> 'technical_spec_id',
			'model'			=> '\App\Models\TechnicalSpecs',
			'value_name'	=> 'details',
			'value_id'		=> 'id',
		],
		'asset_status_id'		=> [
			'display_name'  => 'Asset Status',
			'db_name' 		=> 'asset_status_id',
			'model' 		=> '\App\Models\AssetStatus',
			'value_name'	=> 'name',
			'value_id'		=> 'id',
		],
		'asset_tag'				=> [
			'display_name'  => 'Asset Tag #',
			'db_name' 		=> 'asset_tag',
			'model' 	 	=> 'Facades\App\Services\Filter\AssetTag',
			'value_name' 	=> 'asset_tag',
			'value_id'		=> 'asset_tag',
		],
		'serial_no'				=> [
			'display_name'  => 'Serial #',
			'db_name' 		=> 'serial_no',
			'model' 	 	=> 'Facades\App\Services\Filter\SerialNumber',
			'value_name' 	=> 'serial_no',
			'value_id'		=> 'serial_no',
		],
		'imei'					=> [
			'display_name'  => 'IMEI #',
			'db_name' 		=> 'imei',
			'model' 		=> 'Facades\App\Services\Filter\Imei',
			'value_name'	=> 'imei',
			'value_id'		=> 'imei',
		],
		'carrier'			=> [
			'display_name'  => 'Mobile Carrier',
			'db_name' 		=> 'carrier_id',
			'model' 		=> '\App\Models\Carrier',
			'value_name'	=> 'name',
			'value_id'		=> 'id',
		],
		'age'					=> [],


		'po_no'					=> [
			'display_name'  => 'PO #',
			'db_name' 		=> 'po_id',
			'model' 	 	=> 'Facades\App\Services\Filter\PurchaseNumber',
			'value_name' 	=> 'po_id',
			'value_id'		=> 'po_id',
		],

		'vendor_id'					=> [
			'display_name'  => 'Vendor',
			'db_name' 		=> 'vendor_id',
			'model' 	 	=> '\App\Models\Vendor',
			'value_name' 	=> 'name',
			'value_id'		=> 'id',
		],
		'original_value' => [
			'display_name'  => 'Asset Value',
			'db_name' 		=> 'asset_value',
			'model' 	 	=> 'Facades\App\Services\Filter\AssetValue',
			'value_name' 	=> 'asset_value',
			'value_id'		=> 'asset_value',
			'is_number'		=> true
		],
		'depreciated_value'	=> [
			'display_name'  => 'Depreciation Value',
			'db_name' 		=> 'depreciated_value',
			'model' 	 	=> 'Facades\App\Services\Filter\AssetDepreciationValue',
			'value_name' 	=> 'depreciated_value',
			'value_id'		=> 'depreciated_value',
			'is_number'		=> true
		],
		'ticket_no'				=> [
			'display_name'  => 'Ticket #',
			'db_name' 		=> 'ticket_no',
			'model' 		=> 'Facades\App\Services\Filter\TicketNumber',
			'value_name'	=> 'ticket_no',
			'value_id'		=> 'ticket_no',
		],
		'user' 	  				=> [
			'display_name'  => 'User',
			'db_name' 		=> 'user_id',
			'model' 	 	=> '\App\User',
			'value_name' 	=> 'userName',
			'value_id'		=> 'id',
			'next_row'		=> true,
		],
		'department' 	  			=> [
			'display_name'  => 'Department',
			'db_name' 		=> 'department_id',
			'model' 	 	=> '\App\Models\Department',
			'value_name' 	=> 'name',
			'value_id'		=> 'id',
		],
		'employee_type' 	  			=> [
			'display_name'  => 'User Type',
			'db_name' 		=> 'employee_type_id',
			'model' 	 	=> '\App\Models\EmployeeType',
			'value_name' 	=> 'name',
			'value_id'		=> 'id',
		],
		'work_location' 	    => [
			'display_name'  => 'Work Location',
			'db_name'		=> 'city',
			'model' 	 	=> '\App\User',
			'value_name'    => 'city',
			'value_id'		=> 'id',
		],
		'site_code' 				=> [
			'display_name'  => 'Site Code',
			'db_name'		=> 'site_code_id',
			'model' 	 	=> '\App\Models\SiteCode',
			'value_name' 	=> 'code',
			'value_id'		=> 'id',
		],
		'building' 				=> [
			'display_name'  => 'Building',
			'db_name'		=> 'building',
			'model' 	 	=> '\App\Models\Location',
			'value_name' 	=> 'building',
			'value_id'		=> 'id',
		],
		'location' 				=> [
			'display_name'  => 'Location',
			'db_name'		=> 'location_id',
			'model' 	 	=> '\App\Models\Location',
			'value_name' 	=> 'room_name',
			'value_id'		=> 'id',
		],

		'lock_status'				=> [
			'display_name'  => 'Lock Status',
			'db_name' 		=> 'lock_status',
			'model' 	 	=> 'Facades\App\Services\Filter\LockStatus',
			'value_name' 	=> 'lock_status',
			'value_id'		=> 'lock_status',
			'next_row'		=> true,
		],
	],

	'boolean' => [
		'legalhold'		=> [
			'display_name'	=> 'Legal Hold',
			'db_name'		=> 'legalhold',
		],
		// 'wipe_confirmation'		=> [
		// 	'display_name'	=> 'Wipe Confirmation',
		// 	'db_name'		=> 'wipe_confirmation',
		// ],
		'end_of_life_data_wipe_certificate'	=> [
			'display_name'	=> 'End of Life Data Wipe Certificate',
			'db_name'		=> 'ewaste_certificate',
		],
	],

	'radioButton' => [
		'location_status'		=> [
			'display_name'	=> 'Location',
			'relation'		=> 'location',
			'db_name'		=> 'status',
		],
		'user_status'			=> [
			'display_name'	=> 'User',
			'relation'		=> 'user',
			'db_name'		=> 'status',
		],
		'linked' => [
			'display_name' => 'Linked',
			'relation' => 'childrenAsset',
			'db_name' => 'parent_asset_id',
			'option_1' => 'Yes',
			'option_2' => 'No'
		],
	],

	'dates_from' => [
		'date_deployed'			=> 'date_deployed_from',
		'lease_start_date'		=> 'lease_start_date_from',
		'lease_end_date'		=> 'lease_end_date_from',
		'loaner_return_date'	=> 'loaner_return_date_from',
		'loaner_retention_date'	=> 'loaner_retention_date_from',
		'linked_date'			=> 'linked_date_from',
		'lost_date'				=> 'lost_date_from',
		'created_at'			=> 'created_at_from',
		'warranty_end_date'		=> 'warranty_end_date_from',
		'last_modified_date'	=> 'last_modified_date_from',
		'last_status_update'	=> 'last_status_update_from',
	],

	'dates_to' => [
		'date_deployed'			=> 'date_deployed_to',
		'lease_start_date'		=> 'lease_start_date_to',
		'lease_end_date'		=> 'lease_end_date_to',
		'loaner_return_date'	=> 'loaner_return_date_to',
		'loaner_retention_date'	=> 'loaner_retention_date_to',
		'linked_date'			=> 'linked_date_to',
		'lost_date'				=> 'lost_date_to',
		'created_at'			=> 'created_at_to',
		'warranty_end_date'		=> 'warranty_end_date_to',
		'last_modified_date'	=> 'last_modified_date_to',
		'last_status_update'	=> 'last_status_update_to',
	],

	'month_year_range' => [
		'support_end_date' => [
			'display_name' => 'Support End Date Range',
			'db_name' => 'support_end_date',
			'field_name' => 'support_end_date',
			'model' => '\App\Models\TechnicalSpecs',
		]
	],

	'months' => [
		'1' => 'January',
		'2' => 'February',
		'3' => 'March',
		'4' => 'April',
		'5' => 'May',
		'6' => 'June',
		'7' => 'July',
		'8' => 'August',
		'9' => 'September',
		'10' => 'October',
		'11' => 'November',
		'12' => 'December',

	],

	'months' => [
		'1' => 'January',
		'2' => 'February',
		'3' => 'March',
		'4' => 'April',
		'5' => 'May',
		'6' => 'June',
		'7' => 'July',
		'8' => 'August',
		'9' => 'September',
		'10' => 'October',
		'11' => 'November',
		'12' => 'December',

	],
];
