<?php

return [

    'assets' => [

        'filter_fields' => ['asset_tag', 'serial_no', 'po_id', 'imei', 'ticket_no', 'wipe_confirmation', 'host_name'],

        'relational_filter_fields' => [
            'asset_status' => [
                'db_field' => 'name',
                'relation' => 'assetStatus'

            ],
            'asset_type' => [
                'db_field' => 'name',
                'relation' => 'assetType'

            ],
            'email' => [
                'db_field' => 'email',
                'relation' => 'user'

            ],
            'location' => [
                'db_field' => 'room_name',
                'relation' => 'location'

            ],
            'manufacturer' => [
                'db_field' => 'name',
                'relation' => 'makeAndModel.manufacturer'
            ],
            'carrier' => [
                'db_field' => 'name',
                'relation' => 'carrier'
            ],
            'tracking_id' => [
                'db_field' => 'tracking_number',
                'relation' => 'assetTracking'
            ],
            'technical_specs' => [
                'db_field' => 'details',
                'relation' => 'technicalSpec'
            ]
        ],
        'relational_date_fields' => [
            'hire_date' => [
                'db_field' => 'hire_date',
                'relation' => 'user'
            ],
            'terminated_date' => [
                'db_field' => 'terminated_date',
                'relation' => 'user'
            ]

        ],
        'filter_date_fields' => [
            'created_date' => [
                'db_field' => 'assets.created_at',
            ],
            'warranty_end_date' => [
                'db_field' => 'warranty_end_date',
            ],
            'certificate_added_date' => [
                'db_field' => 'certificate_added_date',
            ],
            'end_of_life_date' => [
                'db_field' => 'end_of_life_date',
            ],
            'cancelled_date' => [
                'db_field' => 'cancelled_date',
            ],
            'lost_date' => [
                'db_field' => 'lost_date',
            ],
            'linked_date' => [
                'db_field' => 'linked_date',
            ],
            'loaner_retention_date' => [
                'db_field' => 'loaner_retention_date',
            ],
            'loaner_return_date' => [
                'db_field' => 'loaner_return_date',
            ],
            'lease_start_date' => [
                'db_field' => 'lease_start_date',
            ],
            'lease_end_date' => [
                'db_field' => 'lease_end_date',
            ],
            'modified_date' => [
                'db_field' => 'assets.updated_at',
            ],
            'last_status_update' => [
                'db_field' => 'last_status_update',
            ],
        ],

    ],

    'users' => [

        'filter_fields' => ['first_name', 'last_name', 'employee_id', 'email'],

        'filter_mapping_fields' => [
            'work_location' => 'city'
        ],

        'filter_fields_bool' => [
            'status' => [
                'active' => 1,
                'terminated' => 0
            ],

            'legalhold' => [
                'yes' => 1,
                'no' => 0
            ]
        ],

        'relational_filter_fields' => [
            'teqtivity_role' => [
                'db_field' => 'name',
                'relation' => 'userType'

            ],
            'department' => [
                'db_field' => 'name',
                'relation' => 'department'

            ],
            'title' => [
                'db_field' => 'name',
                'relation' => 'position'

            ],
            'user_type' => [
                'db_field' => 'name',
                'relation' => 'employeeType'
            ],
        ],

        'filter_date_fields' => [
            'created_date' => [
                'db_field' => 'created_at',
            ],
            'hire_date' => [
                'db_field' => 'hire_date',
            ],
            'terminated_date' => [
                'db_field' => 'terminated_date',
            ],
            'modified_date' => [
                'db_field' => 'updated_at',
            ],

        ],
    ],

    'locations' => [

        'filter_fields' => ['room_name'],

        'relational_filter_fields' => [
            'site_code' => [
                'db_field' => 'code',
                'relation' => 'siteCode'

            ],
            'country' => [
                'db_field' => 'name',
                'relation' => 'siteCode.country'

            ],
            'region' => [
                'db_field' => 'name',
                'relation' => 'siteCode.region'

            ],
            'location_type' => [
                'db_field' => 'location_type_name',
                'relation' => 'locationType'

            ],
        ],

        'filter_date_fields' => [
            'created_date' => [
                'db_field' => 'created_at',
            ],
            'modified_date' => [
                'db_field' => 'updated_at',
            ],

        ],
    ],

    'hardwareStandards' => [

        'filter_fields' => ['name'],

        'relational_filter_fields' => [
            'manufacturer' => [
                'db_field' => 'name',
                'relation' => 'manufacturer'

            ],
            'asset_type' => [
                'db_field' => 'name',
                'relation' => 'assetType'

            ],
        ],

        'filter_date_fields' => [
            'created_date' => [
                'db_field' => 'created_at',
            ],
            'modified_date' => [
                'db_field' => 'updated_at',
            ],

        ],
    ],

    'techSpecs' => [

        'filter_fields' => ['details', 'original_value', 'new_value', 'life_of_asset'],

        'relational_filter_fields' => [
            'hardware_standard' => [
                'db_field' => 'name',
                'relation' => 'makeAndModel'

            ],
            'manufacturer' => [
                'db_field' => 'name',
                'relation' => 'makeAndModel.manufacturer'

            ],
            'asset_type' => [
                'db_field' => 'name',
                'relation' => 'makeAndModel.assetType'

            ],
        ],

        'filter_date_fields' => [
            'created_date' => [
                'db_field' => 'created_at',
            ],
            'modified_date' => [
                'db_field' => 'updated_at',
            ],

        ]
    ],
];
