<?php

namespace App\Services\Vendor;

use App\Models\Vendor;

class VendorData
{


    public function filter()
    {
        $vendors = Vendor::with(['region', 'assetType', 'softwareAssets']);
        $region       = isset(request('form')['region_id']) ? request('form')['region_id'] : '';
        $vendor    = isset(request('form')['vendor']) ? request('form')['vendor'] : '';
        if ($region) {
            if (is_array($region)) {
                $vendors->whereIn('region_id', $region);
            } else {
                $vendors = $vendors->where('region_id', $region);
            }
        }

        if ($vendor) {
            if (is_array($vendor)) {
                $vendors->whereIn('id', $vendor);
            } else {
                $vendors = $vendors->where('id', $vendor);
            }
        }
        $count   = $vendors->count();
        $vendors = $vendors->orderBy('name');
        $vendors = $vendors->get();


        return compact('vendors', 'count');
    }

    public function getVendorData($vendors, $start, $data)
    {
        $parentIndex = $start;

        foreach ($vendors as $key => $vendor) {

            $parentId = $vendor->id;

            $parentIndex++;

            $nestedData = $this->getNestedData($vendor, $parentIndex);

            $data[] = $nestedData;
        }

        return $data;
    }

    public function getNestedData($vendor, $index)
    {

        $nestedData['id']                   = $index;
        $nestedData['name']                 = $vendor->name;

        $nestedData['action']               = "<div class='btn-toolbar'><a href=''  data-toggle='modal' data-vendor-id='" . $vendor->id . "' data-target='#editVendorModal' class='btn btn-link'><i class='icon icon-n-edit'></i></a>";
        if ($vendor->softwareAssets->count() == 0 && $vendor->assets->count() == 0) {
            $nestedData['action']   .= "<a href='javascript:void(0)' class='btn btn-link remove' data-vendor-id='" . $vendor->id . "' ><i class='icon icon-delete-forever'></i></a>";
        }
        $nestedData['action']   .= "</div>";

        return $nestedData;
    }

    /**
     * Create the vendor category relation
     * 
     * @param array $categories the categories id
     * @param int $vendorId the vendor id
     * 
     * @return void
     */
    function createVendorCategoryRelation($vendorId, $categories)
    {
        $vendor = Vendor::find($vendorId);

        if (!$vendor) {
            return;
        }

        $vendor->vendorCategories()->sync($categories);
    }
}
