<?php

namespace App\Services\User;

use App\Http\Responses\ReportOutputData;
use App\Http\Traits\UserDataFetcherTrait;
use App\Repositories\UserRepository;
use App\User;
use Illuminate\Support\Str;

class UserService
{

    use UserDataFetcherTrait;
    /**
     * Constructor  OF User service class
     * @param  protected
     * @param  protected
     */
    public function __construct(protected UserRepository $userRepository, protected  ReportOutputData $reportOutputData)
    {
    }

    /**
     * Store users in the database.
     *
     * @param array $userMeta The user metadata.
     * @throws Some_Exception_Class Description of exception.
     * @return array The errors encountered during the process.
     */
    public function storeUsers($userMeta)
    {
        $errors = [];
        if (!is_array($userMeta['first_name'])) {
            // $userMeta = array_map(fn ($a) => [$a], request()->all());
            $userMeta = array_map(function ($a) {
                return [$a];
            }, request()->all());
        }
        for ($i = 0; $i < count($userMeta['first_name']); $i++) {
            $data = $this->getDataToStoreUsers($i, $userMeta);

            $existUser = User::where('email', $data['email'])->first();
            if (!$existUser) {
                $user = User::create($data);
                // $user->assignRole(optional($user->userType)->name); // commented as there is user created event
            } else {
                $errors[] = 'Email already exists in line no ' . (is_numeric($i) ? ($i + 1) : "");
            }
        }

        return $errors;
    }

    /**
     * Retrieves data to store users.
     *
     * @param int $count the count of user meta
     * @param array $userMeta the user meta array
     * @return array the user data array
     */
    public function getDataToStoreUsers($count, $userMeta)
    {
        $userData['first_name']               = isset($userMeta['first_name']) ? $userMeta['first_name'][$count] : '';
        $userData['last_name']                = isset($userMeta['last_name']) ? $userMeta['last_name'][$count] : '';
        $userData['employee_id']              = isset($userMeta['employee_id']) ? $userMeta['employee_id'][$count] : '';
        $userData['hire_date']                = isset($userMeta['hire_date'][$count]) ? convert_to_db_date($userMeta['hire_date'][$count]) : '';
        $userData['is_rehire']                = isset($userMeta['is_rehire']) ? $userMeta['is_rehire'][$count] : NULL;
        $userData['reason']                   = isset($userMeta['reason']) ? $userMeta['reason'][$count] : '';
        $userData['email']                    = isset($userMeta['email']) ? $userMeta['email'][$count] : '';
        $userData['change_effective_date']    = isset($userMeta['change_effective_date']) ? $userMeta['change_effective_date'][$count] : '';
        $userData['business_title']           = isset($userMeta['business_title']) ? $userMeta['business_title'][$count] : '';
        $userData['location_id']              = isset($userMeta['location_id']) ? $userMeta['location_id'][$count] : '';
        $userData['city']                     = isset($userMeta['city']) ? $userMeta['city'][$count] : '';
        $userData['manager_name']             = isset($userMeta['manager_name']) ? $userMeta['manager_name'][$count] : '';
        $userData['supervisory_organization'] = isset($userMeta['supervisory_organization']) ? $userMeta['supervisory_organization'][$count] : '';
        $userData['company']                  = isset($userMeta['company']) ? $userMeta['company'][$count] : '';
        $userData['cost_center']              = isset($userMeta['cost_center']) ? $userMeta['cost_center'][$count] : '';
        $userData['department_id']            = isset($userMeta['department']) ? $this->getDepartmentIdFromName($userMeta['department'][$count]) : '';
        $userData['original_hire_date']       = isset($userMeta['original_hire_date']) ? $userMeta['original_hire_date'][$count] : '';
        $userData['terminated_date']          = isset($userMeta['terminated_date']) ? convert_to_db_date($userMeta['terminated_date'][$count]) : '';
        $userData['employee_type_id']         = isset($userMeta['employee_type']) ? $this->getOrCreateEmployeeTypeIdByName($userMeta['employee_type'][$count]) : '';

        $userData['position_id']                = isset($userMeta['business_title']) ? $this->getOrCreatePositionIdByName($userMeta['business_title'][$count]) : '';

        $userData['password']     = '';
        $userData['user_type_id'] = $userMeta['user_type_id'][$count] ? $userMeta['user_type_id'][$count] : 4;
        $userData['email']   = isset($userMeta['email']) ? $userMeta['email'][$count] : '';

        return $userData;
    }
}
