<?php

namespace App\Services\Terminations\HrCollection;

use App\Repositories\TermAssets;
use Carbon\Carbon;

class TermsCollectionReportGraphService
{
    protected $repository;

    public function __construct(TermAssets $repository)
    {
        $this->repository = $repository;
    }

    public function generateGraphData()
    {
        $year = carbon::now()->year;
        $lastYear = $year - 1;
        $currentYearData = [];
        $months = [];
        $lastYearData = [];

        for ($month = 1; $month < 13; $month++) {
            $date = create_date_with_year_month_date($year, $month, 1);
            $firstDay = $date->format('m/d/Y');
            $lastDay = $date->endOfMonth()->format('m/d/Y');
            $months[] = $date->format('F');

            $users = $this->getCount($firstDay, $lastDay);

            $lastYearDate = create_date_with_year_month_date($lastYear, $month, 1);
            $lastYearFirstDay = $lastYearDate->format('m/d/Y');
            $lastYearLastDay = $lastYearDate->endOfMonth()->format('m/d/Y');
            $lastYearCount = $this->getCount($lastYearFirstDay, $lastYearLastDay);

            $currentYearData['toCollect'][] = $users['toCollect'];
            $currentYearData['received'][] = $users['received'];

            $lastYearData['toCollect'][] = $lastYearCount['toCollect'];
            $lastYearData['received'][] = $lastYearCount['received'];
        }

        return compact('months', 'year', 'lastYearData', 'currentYearData');
    }

    /**
     * Returns collected/uncollected assets count for given date range & user type.
     * @param date $dateFrom
     * @param date $dateTo
     * @param string $type
     * @return array
     */
    public function getCount($dateFrom, $dateTo)
    {
        $users = $this->repository->getCollectionStatistics();
        $users = $this->repository->searchUserWithFromDate($users, $dateFrom);
        $users = $this->repository->searchUserWithToDate($users, $dateTo);
        $users = $users->get();
        $toCollect = 0;
        $received = 0;

        foreach ($users as $key => $user) {
            $toCollect = $toCollect + $user->term_asset_count;
            $received  = $received + $user->received_asset_count;
        }
        $result['toCollect'] = $toCollect;
        $result['received'] = $received;

        return $result;
    }
}
