<?php

namespace App\Services\StatusUpdateConditions;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

class StatusRetainHold implements StatusAllowedForAsset
{
	/**
	 * Check if the asset can be updated from this status.
	 *
	 * @param mixed $asset The asset to be checked.
	 * @return bool
	 */
	public function canbeUpdatedFromThisStatus($asset)
	{
		// Allow Admins to move from Return Hold , even before the Return Hold expiration date 
		if (Auth::user()->hasAnyRole(['Administrator', 'Super Admin'])) {
			return true;
		}
		$assetToUpdate = $asset->first();
		$loanerRetentionDate = $assetToUpdate->loaner_retention_date;

		if (!$loanerRetentionDate && $assetToUpdate->last_status_update) {
			// Cannot be updated until the retention date passed
			$daysDiff = Carbon::createFromDate($assetToUpdate->getRawOriginal('last_status_update'))->diffInDays(Carbon::now());
			if ($daysDiff <= config('date.period.retain_hold')) {
				return false;
			}
		}

		// Check if the asset has a loaner_retention_date and the date has passed
		if ($loanerRetentionDate && (Carbon::now() <= Carbon::parse($loanerRetentionDate)->utc())) {
			return false;
		}

		return true;
	}
	public function allowedForAsset($asset)
	{
		return true;
	}

	public function afterUpdate($asset)
	{
		return false;
	}
}
