<?php

namespace App\Services\StatusUpdateConditions;

use Carbon\Carbon;

class StatusLikeNew implements StatusAllowedForAsset
{
	/**
	 * Check if the asset can be updated from this status.
	 *
	 * @param mixed $asset The asset to be checked.
	 * @return bool
	 */
	public function canbeUpdatedFromThisStatus($asset)
	{
		return true;
	}

	public function allowedForAsset($asset)
	{
		$monthDiff = Carbon::parse($asset->first()->created_at)->diffInMonths(Carbon::now());
		if ($monthDiff > config('date.period.like_new')) {
			return false;
		}
		return true;
	}

	public function afterUpdate($asset)
	{
		$asset->update([
			'loaner_return_date' => NULL,
			'loaner_retention_date' => NULL
		]);
	}
}
