<?php

namespace App\Services\StatusUpdateConditions;

use Illuminate\Support\Facades\Auth;

class StatusLegalHold implements StatusAllowedForAsset
{
	/**
	 * Check if the asset can be updated from this status.
	 *
	 * @param mixed $asset The asset to be checked.
	 * @return bool
	 */
	public function canbeUpdatedFromThisStatus($asset)
	{
		// Only admins can update asset from legal hold status
		// if (Auth::user()->hasAnyRole(['Administrator', 'Super Admin'])) {
		// 	return true;
		// }

		return true;
	}

	public function allowedForAsset($asset)
	{
		return true;
	}

	public function afterUpdate($asset)
	{
		$asset->update([
			'loaner_return_date' => NULL,
			'loaner_retention_date' => NULL
		]);
	}
}
