<?php

namespace App\Services\StatusUpdateConditions;

use App\Models\Location;

class StatusInstalled implements StatusAllowedForAsset
{
	/**
	 * Check if the asset can be updated from this status.
	 *
	 * @param mixed $asset The asset to be checked.
	 * @return bool
	 */
	public function canbeUpdatedFromThisStatus($asset)
	{
		return true;
	}

	public function allowedForAsset($asset)
	{
		if (request()->has('location_id')) {
			if (Location::find(request('location_id'))->locationType->location_type_name == "Warehouse") {
				return false;
			}
		}

		return true;
	}

	public function afterUpdate($asset)
	{
		$asset->update([
			'loaner_return_date' => NULL,
			'loaner_retention_date' => NULL
		]);
	}
}
