<?php

namespace App\Services\StatusUpdateConditions;

class StatusCommon implements StatusAllowedForAsset
{
	/**
	 * Check if the asset can be updated from this status.
	 *
	 * @param mixed $asset The asset to be checked.
	 * @return bool
	 */
	public function canbeUpdatedFromThisStatus($asset)
	{
		return true;
	}

	/**
	 * Checks if the asset is allowed to be updated to this status.
	 *
	 * @param mixed $asset The asset to be checked.
	 * @return bool
	 */
	public function allowedForAsset($asset)
	{
		return true;
	}

	/**
	 * Set the loaner return date and loaner retention date to NULL after updating the asset to this status.
	 *
	 * @param Asset $asset The asset that is being updated.
	 */
	public function afterUpdate($asset)
	{
		$asset->update([
			'loaner_return_date' => NULL,
			'loaner_retention_date' => NULL
		]);
	}
}
