<?php

namespace App\Services\StatusUpdateConditions;

class StatusBrandNew implements StatusAllowedForAsset
{
	/**
	 * Check if the asset can be updated from this status.
	 *
	 * @param mixed $asset The asset to be checked.
	 * @return bool
	 */
	public function canbeUpdatedFromThisStatus($asset)
	{
		return true;
	}

	public function allowedForAsset($asset)
	{

		$asset = $asset->statusEmpty() //cannot be changed to new if its of any other status
			->userNotAssigned(); //users should not be assigned

		if (!$asset->count()) {
			return false;
		}

		if (!$asset->first()->location->count()) {
			return false;
		}

		return true;
	}

	public function afterUpdate($asset)
	{
		$asset->update([
			'loaner_return_date' => NULL,
			'loaner_retention_date' => NULL
		]);
	}
}
