<?php

namespace App\Services\SoftwareLicense;

use App\Models\SoftwareLicense\SoftwareLicense;
use App\Models\SoftwareLicense\SoftwareLicenseManufacturer;
use App\Models\SoftwareLicense\SoftwareLicenseUser;
use App\Repositories\SoftwareLicense\LicenseRepository;
use App\Services\SoftwareLicense\LicenseService;
use App\User;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class SlackSoftwareDataService
{
    
    protected $licenseRepo;
    protected $licenseService;

    public function __construct(LicenseRepository $licenseRepo, LicenseService $licenseService)
    {         
        $this->licenseRepo = $licenseRepo;
        $this->licenseService = $licenseService;
    }
    
    
    
    /**
     * Create or update Zoom Software Asset
     * 
     * @return bool
     */
    public function createOrUpdateSoftwareAsset($integrationStatus)
    {
        try {
            $manufacturer = SoftwareLicenseManufacturer::updateOrCreate(['name' => 'Slack'], [
                'name' => 'Slack'
            ]);
            SoftwareLicense::whereNull('deleted_at')->updateOrCreate(['name' => 'Slack'], [
                'name' => 'Slack',
                'software_license_manufacturer_id' => $manufacturer->id,
                'status' => $integrationStatus,
                'type'   => 'saas_cloud',
                'license_type' => 'subscription'
            ]);
            
            return true;
        } catch (Exception $e) {
            Log::channel('daily')->error('Slack Software Asset Create and Update : ' . $e->getMessage());
            return false;
        }
    }

}