<?php

namespace App\Services\SoftwareLicense\ImportedAssets;


interface ImportedAssetsServiceInterface
{
    // Integrate the imported software asset with the credential page 
    public function integrationStatusChange();

    //Update total purchased license count of the software asset from API
    public function updateLicencePurchasedCount($credentialsData, $assetDetail);

    // Add all tqt and non tqt users of the software asset to a separate table 
    public function createMembers($credentialsData);

    // Sync software asset members with matching tqt users 
    public function softwareAssetMemberListSync($assetDetails);

    // Update software asset owner with owner role
    public function updateSoftwareAssetOwner($assetDetails);

    // Update active memebrs count for the software asset from the total license purchased count
    public function updateLicensesUsedCount($assetDetails);

}