<?php

namespace App\Services;

use App\Models\SiteCode;
use App\Models\Country;
use App\Models\Region;

class SiteCodeData
{

    public function filter($siteCodes, $searchText)
    {
        return $siteCodes->where('code', 'like', '%' . $searchText . '%')
            ->orWhereHas('country', function ($query) use ($searchText) {
                $query->where('name', 'like', '%' . $searchText . '%');
            })
            ->orWhereHas('region', function ($query) use ($searchText) {
                $query->where('name', 'like', '%' . $searchText . '%');
            });
    }
}
