<?php

namespace App\Services\ShipmentTracking;

use App\Models\AssetTracking;
use App\Services\Integrations\ShipmentTracking\FedexTracking;
use App\Services\Integrations\ShipmentTracking\UpsTracking;

/** 
 * Service class for tracking the shipment status by using UPS Api
 */
class UpdateShipmentStatusService
{

	public function __construct(FedexTracking $fedexService, UpsTracking $upsService)
	{
		$this->fedexService = $fedexService;
		$this->upsService   = $upsService;
	}


	/**
	 * Updates the shipment status for all active shipments
	 * @return [type]
	 */
	public function updateShipmentStatus()
	{
        setUnlimitedExecutionTimeAndMemoryLimit();

		$trackingNos = AssetTracking::active()->get();
		foreach ($trackingNos as $key => $trackingNo) {
			$trackingDetails = [];

			try {
				if (isUpsTrackingNo($trackingNo->tracking_number)) {
					$trackingDetails = $this->upsService->getTrackingDetails($trackingNo->tracking_number);
				}


				if (!isUpsTrackingNo($trackingNo->tracking_number)) {

					$trackingDetails = $this->fedexService->getTrackingDetails($trackingNo->tracking_number);
				}

				$dataToUpdate    = $this->getTrackingDataToUpdate($trackingDetails);

				if ($dataToUpdate) {
					$trackingNo->update($dataToUpdate);
				}
			} catch (\Throwable $e) {
				// dd($e->getMessage());
				continue;
			}
		}

		return true;
	}

	/**
	 * Creating array for save the tracking details
	 * 
	 * @param $trackingStatus
	 */
	public function getTrackingDataToUpdate($trackingDetails)
	{
		if (empty($trackingDetails)) {
			return false;
		}

		//Check status is invalid or error
		if (in_array($trackingDetails['status'], ['ERROR', 'No tracking information available', 'Invalid tracking number', 'No information found', 'Delivered'])) {
			$dateToUpdate['active'] = 0;

			return $dateToUpdate;
		}

		$dateToUpdate['shipment_status'] = $trackingDetails['status'];
		$dateToUpdate['status_updated_on'] = $trackingDetails['updated_on'];

		return $dateToUpdate;
	}
}
