<?php

namespace App\Services\Settings;

use App\Models\TeqtivityUserHistory;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

class TeqtivityUserService
{
    /**
     * Store teqtivity user history
     * 
     * @return [type]
     */
    public function createHistory($action, $user)
    {
        $history = [
            'user_id' => $user->id,
            'created_by' => Auth::id(),
            'history_assigned_to' => request('history_assigned_to'),
            'action' => $action,
            'description' => $this->getDescription($user, $action),
            'created_at'  => Carbon::now()->format('Y-m-d H:i:s'),
            'updated_at'  => Carbon::now()->format('Y-m-d H:i:s'),
        ];
        TeqtivityUserHistory::create($history);

        return true;
    }

    /**
     * function to make history description sentence
     * 
     * @param $user
     * @param $action
     * 
     * @return description
     */
    private function getDescription($user, $action)
    {
        $description = '';
        if ($action == 'teq_user_created') {
            $description = __('history.TeqUserCreated', [
                'userName' => $user->userName,
                'email'    => $user->email
            ]);
        }

        if ($action == 'teq_user_deleted') {
            $description = __('history.TeqUserDeleted', [
                'userName' => $user->userName,
                'email'    => $user->email
            ]);
        }
        return $description;
    }
}
