<?php

namespace App\Services\Settings\History;

use App\Http\Responses\ReportOutputData;
use App\Repositories\Settings\History\AssetsHistoryRepository;
use App\Repositories\CommonFilterRepository;
use App\Services\Integrations\Tickets\TicketManagementService;

class AssetDetailsHistoryService extends AbstractHistoryService
{
    /**
     * Constructor for class
     *
     * @param AssetsHistoryRepository $repository The asset history repository
     * @param CommonFilterRepository $commonFilterRepository The common filter repository
     * @param ReportOutputData $reportOutputData The report output data
     * @param TicketManagementService $ticketManagementService The ticket management service
     */
    public function __construct(
        protected AssetsHistoryRepository $repository,
        protected CommonFilterRepository $commonFilterRepository,
        protected ReportOutputData $reportOutputData,
        protected TicketManagementService $ticketManagementService
    ) {}

    /**
     * Retrieves and processes data, then returns a compact array containing history and count.
     *
     * @return array
     */
    public function data()
    {
        $inputData = $this->getInputData();
        $assets    = $this->repository->getAssetHistoryData();
        $assets    = $this->filterWithInputData($assets, $inputData);
        $count     = $assets->count();
        $history   = $this->reportOutputData->getOutputData($assets, ['id' => 'desc']);

        return compact('history', 'count');
    }

    /**
     * filterWithInputData function filters the query with the given input data.
     *
     * @param mixed $query The query to be filtered
     * @param array $inputData The input data used for filtering
     * @return mixed The filtered query
     */
    public function filterWithInputData($query, array $inputData)
    {
        $query = $this->commonFilterRepository->filterWithDirectFields($query, 'asset_id', $inputData['asset']);

        return $query;
    }
}
