<?php

namespace App\Services\Security\Crowdstrike\Reports;

use App\Repositories\Security\Crowdstrike\CrowdstrikeReportRepository;

class CrowdstrikeReportService
{

    protected $repository;
    
    /**
     * Constructs a new instance of the class.
     *
     * @param CrowdstrikeReportRepository $repository The repository to be injected.
     */
    public function __construct(CrowdstrikeReportRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Retrieves the vulnerability fields based on the search keyword and type.
     *
     * @param string $search The search keyword.
     * @param string $type The type of vulnerability field.
     * @return Illuminate\Support\Collection The collection of vulnerability fields.
     */
    public function getFilterVulnerabilityFields($search, $type)
    {
        $res = $this->repository->getFilterVulnerabilityFields($search, $type);
        $result = $res->mapWithKeys(function ($item, $key) use ($type) {
                    return [
                        $key => [
                            'id' => $item[$type],
                            'text' => $item[$type],
                        ]
                    ];
                });
    
        return $result;
    }

}
