<?php

namespace App\Services\Security\Crowdstrike;

use App\Repositories\Security\Crowdstrike\CrowdstrikeReportRepository;

class CveDataService
{

    protected $repository;
    
    /**
     * Constructs a new instance of the class.
     *
     * @param CrowdstrikeReportRepository $repository The repository to be injected.
     */
    public function __construct(CrowdstrikeReportRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Retrieves a single CVE data.
     *
     * @param mixed $id The identifier of the CVE data.
     * 
     * @return mixed The single CVE data.
     */
    public function getSingleCveData($id)
    {
        return $this->repository->getSingleCveData($id);
    }

    /**
     * Retrieves the assets associated with a specific CVE.
     *
     * @param int $cveId The ID of the CVE.
     * 
     * @return object The assets associated with the CVE.
     */
    public function getcveAssets($cveId)
    {
        return $this->repository->getcveAssets($cveId);
    }

    /**
     * Retrieves the CSV detail assets widget data.
     *
     * @param array $cveAssetsIds The array of CVE asset IDs.
     *
     * @return array The array containing the asset type with their count.
     */
    public function getCsvDetailAssetsWidgetData($cveAssetsIds)
    {
        $assetTypesWithCount = $this->repository->getAssetTypesWithCount($cveAssetsIds);

        return [
            'assetTypeWithCount' => $assetTypesWithCount
        ];
    }
}