<?php

namespace App\Services\Security\Crowdstrike;

use App\Models\Asset;
use App\Models\AssetVulnerability;

class CrowdstrikeSyncDataService
{

    /**
     * Get Assets With Crowdsrike ID 
     *
     * Retrieves all CrowdStrike assets
     *
     * @return mixed
     */
    public function getAssetsWithCrowdstrikeId()
    {
        return Asset::whereNotNull('crowdstrike_id')->select('id', 'crowdstrike_id')->get();
    }

    /**
     * Saves asset vulnerabilities.
     *
     * @param array $vulnerabilities The array of vulnerabilities to be saved.
     * @param int $assetId The asset id associated with the vulnerabilities.
     * 
     * @return void
     */
    public function saveAssetVulnerability($vulnerabilities, $assetId)
    {
        foreach ($vulnerabilities as $vulnerability) {
            $data = [];
            $data['asset_id'] = $assetId;
            $data['cve_id'] = $vulnerability['cve']['id'];
            $data['base_score'] = $vulnerability['cve']['base_score'];
            $data['exprt_rating'] = $vulnerability['cve']['exprt_rating'];;
            $data['severity'] = $vulnerability['cve']['severity'];
            $data['status'] = $vulnerability['status'];
            $data['product_name_version'] = $vulnerability['apps'][0]['product_name_version'];
            $data['product_name_normalized'] = $vulnerability['apps'][0]['product_name_normalized'];
            $data['description'] = $vulnerability['cve']['description'];
            $data['exploitability_score'] = $vulnerability['cve']['exploitability_score'];
            $data['cve_published'] = format_date_iso_datetime_to_db_datetime($vulnerability['cve']['published_date']);
            $data['opened_at'] = format_date_iso_datetime_to_db_datetime($vulnerability['created_timestamp']);

            AssetVulnerability::create($data);
        }
    }
}
