<?php 

namespace App\Services;

use App\Models\Asset;
use App\User;
use App\Models\Location;
use App\Models\Manufacturer;
use App\Models\MakeAndModel;


class SearchAccessories
{
	public function getSearchFields($search)
	{
	
        $resultManufacturer = $this->getSearchManufacturerFields($search);
        $resultMakemodel = $this->getSearchHardwarespec($search);
        $resultLocation = $this->getSearchLocationFields($search);
        $result =$resultManufacturer->union($resultLocation->union($resultMakemodel));
          
        return $result; 
	}

	

    public function getSearchManufacturerFields($search)
    {
        $res = Manufacturer::where('name', 'like', '%'.$search.'%')
                    ->get();

        $result = $res->mapWithKeys(function ($item, $key) {
            return [
                $key => [
                    'value' => $item['name'],
                    'label' => $item['name'],
                ]
            ];
        });

        return $result;
    }

     public function getSearchMakeModelFields($search)
    {
        $res = MakeAndModel::where('name', 'like', '%'.$search.'%')
                    ->get();

        $result = $res->mapWithKeys(function ($item, $key) {
            return [
                $key => [
                    'value' => $item['name'],
                    'label' => $item['name'],
                ]
            ];
        });

        return $result;
    }

    public function getSearchHardwarespec($search)
    {
        $res = MakeAndModel::with('Manufacturer')->where('name', 'like', '%'.$search.'%')->orWhereIn('manufacturer_id',
                        Manufacturer::where('name', 'like', '%'.$search.'%')->pluck('id'))
                    ->get();

        $result = $res->mapWithKeys(function ($item, $key) {
            return [
                $key => [
                    'value' => $item->manufacturer->name." ".$item['name'],
                    'label' => $item->manufacturer->name." ".$item['name'],
                ]
            ];
        });

        return $result;
    }

    

    public function getSearchLocationFields($search)
    {
        $res = Location::where('room_name', 'like', '%'.$search.'%')->get();

        $result = $res->mapWithKeys(function ($item, $key) {
            return [
                $key => [
                    'value' => $item['room_name'],
                    'label' => $item['room_name'],
                ]
            ];
        });

        return $result;
    }

    public function getSearchAssetTagFields($search)
    {
        $res = Asset::where('asset_tag', 'like', '%'.$search.'%')->get();

        $result = $res->mapWithKeys(function ($item, $key) {
            return [
                $key => [
                    'value' => $item['asset_tag'],
                    'label' => $item['asset_tag'],
                ]
            ];
        });

        return $result;
    }

    public function getSearchSerialFields($search)
    {
        $res = Asset::where('serial_no', 'like', '%'.$search.'%')->get();

        $result = $res->mapWithKeys(function ($item, $key) {
            return [
                $key => [
                    'value' => $item['serial_no'],
                    'label' => $item['serial_no'],
                ]
            ];
        });

        return $result;
    }
}

?>