<?php

namespace App\Services\Revivn;

use Illuminate\Support\Str;
use App\Repositories\Revivn\RevivnAssetsRepository;

class RevivnAssetsManagementService
{

    public function __construct(protected RevivnAssetsRepository $repository)
    {
    }

    /**
     * Retrieves the filter fields based on the search and type.
     *
     * @param datatype $search description
     * @param datatype $type description
     * @return Some_Return_Value
     */
    public function getFilterFields($search, $type)
    {
        $res = $this->repository->filterField($search, $type)->get();

        $result = $res->mapWithKeys(function ($item, $key) use ($type) {
            return [
                $key => [
                    'id' => $item[$type],
                    'text' => $item[$type],
                ]
            ];
        });

        return $result;
    }
}
