<?php

namespace App\Services\Reports\CycleCount;

/**
 * Service Class for CycleCount Report File generation
 *
 */
class CycleCountFileGeneratorService
{
    /**
     * Create a csv file with the generated result and save on server
     *
     * @param array $datasScanned        Scanned asset details
     * @param array $datasNotScanned     Not scanned asset details
     * @param array $dataNotInDatabase   Scanned but not in the system asset details
     */
    public function generateCsvFile($datasScanned, $datasNotScanned, $dataNotInDatabase, $assetsMatched, $assetsNotMatched, $accuracy, $reportName, $createdDate, $userName, $positiveVariance, $variance, $count)
    {
        $reportName = str_replace(' ', '_', $reportName) . '.csv';
        $fileName = "variance_reports/" . $reportName; //for saving to DB

        $folderPath = storage_path("app/public/variance_reports");
        // Check if the folder exists, if not, create it
        if (!file_exists($folderPath)) {
            mkdir($folderPath, 0755, true);
        }

        $fileLocation = storage_path("app/public/variance_reports/" . $reportName);
        $file = fopen($fileLocation, 'w');

        fputcsv($file, ['0' => 'Date', '1' => $createdDate]);
        fputcsv($file, ['0' => 'Scanned by', '1' => $userName]);
        fputcsv($file, ['0' => 'Total # of Assets', '1' => $count]);
        fputcsv($file, ['0' => 'Total # of Assets Matched', '1' => $assetsMatched]);
        fputcsv($file, ['0' => 'Total # of Process Errors', '1' => $positiveVariance]);
        fputcsv($file, ['0' => 'Total # of Unknown Shrinkage', '1' => count($datasNotScanned)]);
        fputcsv($file, ['0' => '% of Accuracy', '1' => $accuracy . '%']);
        fputcsv($file, ['0' => '% of Variance', '1' => $variance . '%']);

        fputcsv($file, [
            '#',
            'Scanned Asset Tag #',
            'Serial #',
            'Asset Type',
            'Hardware Standard',
            'Tech Spec',
            'Asset Status',
            'Asset Location',
            'Match at Location (Y/N)',
            'Discrepancy',
            'Error'
        ]);

        $counter = 1;
        foreach ($datasScanned as $key => $value) {
            array_unshift($value, $counter);
            fputcsv($file, $value);
            $counter++;
        }

        foreach ($dataNotInDatabase as $key => $value) {
            array_unshift($value, $counter);
            fputcsv($file, $value);
            $counter++;
        }

        foreach ($datasNotScanned as $key => $value) {
            array_unshift($value, $counter);
            fputcsv($file, $value);
            $counter++;
        }

        fputcsv($file, []);
        fputcsv($file, ['0' => 'Date', '1' => $createdDate]);
        fputcsv($file, ['0' => 'Scanned by', '1' => $userName]);
        fputcsv($file, ['0' => 'Total # of Assets', '1' => $count]);
        fputcsv($file, ['0' => 'Total # of Assets Matched', '1' => $assetsMatched]);
        fputcsv($file, ['0' => 'Total # of Process Errors', '1' => $positiveVariance]);
        fputcsv($file, ['0' => 'Total # of Unknown Shrinkage', '1' => count($datasNotScanned)]);
        fputcsv($file, ['0' => '% of Accuracy', '1' => $accuracy . '%']);
        fputcsv($file, ['0' => '% of Variance', '1' => $variance . '%']);

        fclose($file);

        return $fileName;
    }
}
