<?php

namespace App\Services\Reports;

abstract class AbstractReportService
{
    abstract public function data();
    abstract public function exportData();

    /**
     * Generating data table data from qurey result
     * @param $query Query Result
     * @param $start Starting index
     * @param $data Collection valriable that will return
     *
     * @return array
     */
    public function getReportData($query, $start, $data = [])
    {
        $parentIndex = $start;

        foreach ($query as $singleRecord) {
            $parentIndex++;
            $nestedData = $this->getNestedData($singleRecord, $parentIndex);
            $data[] = $nestedData;
        }

        return $data;
    }

    /**
     * Generating data to export
     *
     * @param $query Query Result
     * @param $data Collection valriable that will return
     * @param $requiredColumns colums to be shown in export file

     * @return array
     */
    public function getReportExportData($query, $data)
    {
        foreach ($query as $singleRecord) {
            $nestedData = $this->getReportNestedData($singleRecord);
            $data[] = $nestedData['export'];
        }

        return $data;
    }
}
