<?php

namespace App\Services;

use Maatwebsite\Excel\Concerns\WithDrawings;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithEvents;

class ReportGraphExport implements WithDrawings, WithHeadings, WithEvents
{
    protected $header;
    protected $image;
    protected $sheetTitle;

    /**
     * Creates a new instance of the class.
     *
     * @param mixed $header The header value.
     * @param mixed $image The image value.
     * @param mixed $sheetTitle The sheet title value.
     */
    public function __construct($header, $image, $sheetTitle)
    {
        $this->header = $header;
        $this->image = $image;
        $this->sheetTitle = $sheetTitle;
    }

    /**
     * Generates the headings for the PHP function.
     *
     * @return array The array containing the headings.
     */
    public function headings(): array
    {
        return [$this->header];
    }

    /**
     * Register the events for the class.
     *
     * @return array
     */
    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $event->sheet->mergeCells('A1:P2');
                $event->sheet->freezePane('A3', 'A3');
                $event->sheet->mergeCells('B5:Q35');
                $event->sheet->setTitle($this->sheetTitle);
            },
        ];
    }

    /**
     * Generate a drawing object with specific properties.
     *
     * @return Drawing The created drawing object.
     */
    public function drawings()
    {
        $drawing = new Drawing();
        $drawing->setName('graph');
        $drawing->setDescription('graph');
        $drawing->setPath($this->image);
        $drawing->setHeight(500);
        $drawing->setOffsetX(5);
        $drawing->setOffsetY(5);
        $drawing->setCoordinates('B5');

        return $drawing;
    }
}
