<?php

namespace App\Services;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;

class ReportGraphDataExport implements FromCollection, WithHeadings, WithEvents, WithColumnWidths
{
    use Exportable;

    protected $data;
    protected $headings;
    protected $sheetTitle;

    /**
     * Constructor for the class.
     *
     * @param mixed $data The data to be assigned.
     * @param mixed $headings The headings to be assigned.
     * @param mixed $sheetTitle The sheet title to be assigned.
     */
    public function __construct($data, $headings, $sheetTitle)
    {
        $this->data = $data;
        $this->headings = $headings;
        $this->sheetTitle = $sheetTitle;
    }

    /**
     * Returns an array containing the widths of each column in the table.
     *
     * @return array An associative array where the keys are the column names and the values are the widths of the columns.
     */
    public function columnWidths(): array
    {
        return [
            'A' => 25,
            'B' => 35,
            'C' => 35,
            'D' => 20,
            'E' => 35,
            'F' => 15,
            'G' => 15,
            'H' => 35,
        ];
    }

    /**
     * Returns a collection of the data.
     *
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return collect($this->data);
    }

    /**
     * Retrieves the headings array.
     *
     * @return array The headings array.
     */
    public function headings(): array
    {
        return $this->headings;
    }

    /**
     * Registers events and returns an array of events with their corresponding actions.
     *
     * @return array
     */
    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $event->sheet->setTitle($this->sheetTitle);
                $event->sheet->getDelegate()->getStyle('1')->applyFromArray([
                    'font' => [
                        'bold' => true,
                    ],
                ]);
            },

        ];
    }
}
