<?php

namespace App\Services;

use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;

class ReportGraphAndDataExport implements WithMultipleSheets
{
    use Exportable;

    protected $data;
    protected $imagePath;
    protected $headings;
    protected $sheetTitle;

    /**
     * Initializes a new instance of the class.
     *
     * @param mixed $data The data to be assigned to the object.
     * @param string $imagePath The path to the image.
     * @param array $headings The headings for the data.
     * @param string $sheetTitle The title of the sheet.
     */
    public function __construct($data, $imagePath, $headings, $sheetTitle)
    {
        $this->data = $data;
        $this->imagePath = $imagePath;
        $this->headings = $headings;
        $this->sheetTitle = $sheetTitle;
    }

    /**
     * Generates an array of sheets for export.
     *
     * @return array The array of sheets for export.
     */
    public function sheets(): array
    {
        return [
            new ReportGraphDataExport($this->data, $this->headings, 'Data List'),
            new ReportGraphExport($this->sheetTitle, $this->imagePath, 'Graph'),
        ];
    }
}
