<?php

namespace App\Services;

use Illuminate\Support\Facades\Log;
use Storage;

class PurchaseFileGenerator
{
	protected $titles = ['Inventory Location', 'Hardware Standard', 'Technical Specifications', 'Available Quantity', 'Weekly Demand', 'Lead Time (weeks)', 'Order Qty (for 6 weeks)', 'Purchase Indicator'];

	protected $file;
	protected $folder = 'app/public/purchase';

	public function create($accessories)
	{
		$fp = $this->csvHeaders();
		foreach ($accessories as $accessory) {

			$purchaseIndicator = $accessory->purchase_indicator ? 'Yes' : 'No';

			$row = [
				optional($accessory->location)->room_name,
				optional(optional($accessory->makeAndModel)->manufacturer)->name . ' ' . optional($accessory->makeAndModel)->name,
				optional($accessory->technicalSpec)->details,
				$accessory->available_quantity,
				$accessory->weekly_demand,
				$accessory->lead_time,
				$accessory->order_quantity,
				$purchaseIndicator
			];

			fputcsv($fp, $row);
		}
		fclose($fp);
		return $this->file;
	}

	public function csvHeaders()
	{
		$this->file = sha1(time()) . '.csv';
		$fp = fopen($this->fullPath(), 'w');
		fputcsv($fp, $this->titles);
		return $fp;
	}

	public function fullPath()
	{
		$folderPath = storage_path($this->folder);
		if (!file_exists($folderPath)) {
			mkdir($folderPath, 0755, true);
			Log::channel('daily')->info('Folder created');
		}

		return storage_path($this->folder . '/' . $this->file);
	}
}
