<?php

namespace App\Services\OperatingSystemCompliance;

use App\Models\OperatingSystemComplianceSettings;
use App\Http\Responses\ReportOutputData;

class AppleComplianceService extends OSComplianceService
{
    protected $settings;
    protected $reportOutputData;

    public function __construct(ReportOutputData $reportOutputData)
    {
        parent::__construct();
        $this->settings = OperatingSystemComplianceSettings::select('os_platform', 'os_version')->where('device_type', 'apple')->first();
        $repositoryName = "\App\Repositories\OsCompliance\\" . config('os-compliance.apple_os.repository');
        $this->repository = new $repositoryName;
        $this->reportOutputData = $reportOutputData;
    }

    /**
     * Making query for the report
     */
    public function data()
    {
        $inputData = $this->getInputData();
        $result = $this->repository->getDevices();
        $result = $this->repository->filterAppleComputerDevices($result);
        $result = $this->repository->filterWithOsComplianceSettings($result, $this->settings);
        $result = $this->repository->filterAppleDevices($result, $inputData);
        $count  = $result->count();
        $result = $this->reportOutputData->getOutputData($result, ['id' => 'desc']);

        return compact('result', 'count');
    }

    /**
     * Creating array for Data table data
     * @param $item Query Result
     * @param $index Starting index
     * @return array
     */
    public function getNestedData($item, $index)
    {
        $commonData = $this->getExportNestedData($item);
        $nestedData = $commonData['report'];
        $nestedData['id']   = $index;
        $nestedData['serial_no'] = generateAssetLink($item->asset?->id, $nestedData['serial_no']);
        $nestedData['user_location'] =  $item->asset ? ($item->asset->user ? generateUserLink($item->asset->user->id, $item->asset->user->userName) : ($item->asset->location ? generateLocationLink($item->asset->location->id, $item->asset->location->room_name) : '')) : '';
        $nestedData['workspace_one_user'] = $item->user_id ? generateUserLink($item->user_id, $item->email) : '';

        return $nestedData;
    }

    /**
     * Making the query for export
     */
    public function exportData()
    {
        $inputData = $this->getInputData();
        $assets = $this->repository->getDevices();
        $assets = $this->repository->filterAppleComputerDevices($assets);
        $assets = $this->repository->filterWithOsComplianceSettings($assets, $this->settings);
        $assets = $this->repository->filterAppleDevices($assets, $inputData);
        $assets = $assets->orderBy('id', 'desc');

        return $assets;
    }

    /**(' . config('os-compliance.apple_os.mdm')
     * Creating array for export data
     * @param $item Query Result
     * @return array
     */
    public function getExportNestedData($item)
    {
        $nestedData['report']['serial_no'] = $nestedData['export']['Serial #'] = disableCSVInjection($item->serial_no ?? '');
        $nestedData['report']['asset_serial_no'] = $nestedData['export']['Serial # (' . config('os-compliance.apple_os.mdm') . ')'] = disableCSVInjection($item->asset ? $item->asset->serial_no : '');
        $nestedData['report']['asset_type'] = $nestedData['export']['Asset Type'] = disableCSVInjection($item->asset ? ($item->asset->assetType ? $item->asset->assetType->name : '') : '');
        $nestedData['report']['hardware_standard'] = $nestedData['export']['Hardware Standard (' . config('os-compliance.apple_os.mdm') . ')'] = disableCSVInjection($item->model ?? '');
        $nestedData['report']['hardware_teqtivity'] = $nestedData['export']['Hardware Standard (Teqtivity)']   = disableCSVInjection(optional(optional($item->asset)->makeAndModel)->name);
        $nestedData['report']['technical_spec'] = $nestedData['export']['Technical Specs'] = disableCSVInjection($item->asset ? optional($item->asset->technicalSpec)->details : '');
        $nestedData['report']['asset_status'] = $nestedData['export']['Asset Status'] = disableCSVInjection($item->asset ? ($item->asset->assetStatus ? $item->asset->assetStatus->name : '') : '');
        $nestedData['report']['user_location'] = $nestedData['export']['User/Location'] = disableCSVInjection($item->asset ? ($item->asset->user ? $item->asset->user->userName : ($item->asset->location ? $item->asset->location->room_name : '')) : ($item->user ? $item->user->userName : ''));
        $nestedData['report']['workspace_one_user'] = $nestedData['export']['User (' . config('os-compliance.apple_os.mdm') . ')'] =  disableCSVInjection($item->email ?? '');
        $nestedData['report']['os_platform'] = $nestedData['export']['OS Platform (' . config('os-compliance.apple_os.mdm') . ')'] = disableCSVInjection($item->platform ?? '');
        $nestedData['report']['os_version'] = $nestedData['export']['OS Version (' . config('os-compliance.apple_os.mdm') . ')'] = disableCSVInjection($item->os_version ?? '');
        $nestedData['report']['latest_version'] = $nestedData['export']['Latest Version'] = disableCSVInjection($this->settings ? $this->settings->os_version : '');
        $nestedData['report']['check_in_date'] = $nestedData['export']['Last Check In'] = $item->last_seen ?? '';

        return $nestedData;
    }


}
