<?php 

namespace App\Services;

use Facades\App\Services\Notifications; 
use Illuminate\Pagination\LengthAwarePaginator;

class NotificationData
{
    public function filter($request)
    {
        $region = isset(request('form')['region']) ? request('form')['region'] : '';
        $siteCode = isset(request('form')['site_code']) ? request('form')['site_code'] : '';
        $type = isset(request('form')['type']) ? request('form')['type'] : '';

        $notifications = collect(Notifications::getAll());

        if ($region) {
            $notifications = $notifications->filter(function($record) use($region) {
                return in_array($record['region_id'], $region);
            });
        }

        if ($siteCode) {
            $notifications = $notifications->filter(function($record) use($siteCode) {
                return in_array($record['site_code_id'], $siteCode);
            });
        }

        if ($type) {
            $notifications = $notifications->filter(function($record) use($type) {
                return in_array($record['type'], $type);
            });
        }

        $start = request('start');
        $limit = request('length');
        $count = $notifications->count();
        if($limit != -1) {
            // Get current page form url e.x. &page=1
            $currentPage = LengthAwarePaginator::resolveCurrentPage();

            // Define how many items we want to be visible in each page
            $perPage = 50;
 
            // Slice the collection to get the items to display in current page
            $currentPageItems = $notifications->slice(($currentPage * $perPage) - $perPage, $perPage)->all();

            $number = (($currentPage - 1) * $perPage) + 1 ;
     
            // Create our paginator and pass it to the view
            $paginatedItems= new LengthAwarePaginator($currentPageItems , count($notifications), $perPage);
 
            // set url path for generted links
            $paginatedItems->setPath($request->url());
        }
        
        $notifications = $paginatedItems;
        return compact('notifications', 'count');
    }

    public function getNotificationData($notifications, $start, $data)
    {
        $parentIndex = $start;

        foreach ($notifications as $key => $notification) {
            
            $parentIndex++;

            $nestedData = $this->getNestedData($notification, $parentIndex, '');
            
            $data[] = $nestedData;

        }

        return $data;
    }

    public function getNestedData($notification, $index, $last)
    {        
        $nestedData['dataLast'] = $last;
        $nestedData['id'] = $index;
        $nestedData['notification'] = $notification['description'];

        return $nestedData;
    }
}