<?php

namespace App\Services\NewHire;

use App\Models\UserJiraMappings;
use App\Services\JiraService;
use App\Repositories\UserRepository;
use App\User;

class NewHireTicketService
{
    public $jiraService;
    public $newHireEmployeesData;
    public $userRepository;

    public function __construct(JiraService $jiraService, UserRepository $userRepository)
    {
        $this->jiraService = $jiraService;
        $this->userRepository = $userRepository;
    }

    /**Get New Hire Users list
     * @return [type]
     */
    public function getNewHireUsers()
    {
        return $this->userRepository->getHireUsersBetweenDate(get_week_first_day())->get();
    }

    /**Calls API to jira for updating ticket information
     * @param User $user
     * 
     * @return [type]
     */
    public function getAssignedDetailsFromJira(User $user)
    {
        $jiraDetails = $this->jiraService->getIssueByUserEmailAndComponent($user->email);

        if (isset($jiraDetails['issues'])) {
            if (!empty($jiraDetails['issues'])) {
                return [
                    'jiraDetails' => $jiraDetails,
                    'deviceRequest' => $this->getRequestedLaptopDetails($jiraDetails, config('jira-fields.display.device_requested')),
                    'jiraTicketStatus' => $this->jiraService->getIssueStatus($jiraDetails['issues'][0]['key']),
                ];
            }
        }

        return null;
    }

    /**Update/enter the ticket, device inormation from jira to new hire user
     * @param array|null $assignedUserDetails
     * @param int $userId
     * 
     * @return [type]
     */
    public function addDetailsToNewHire(array $assignedUserDetails = null, int $userId)
    {
        if ($assignedUserDetails) {
            return UserJiraMappings::create([
                'user_id'    => $userId,
                'ticket_no'    => $assignedUserDetails['jiraDetails']['issues'][0]['key'],
                'device_requested' => $assignedUserDetails['deviceRequest'],
            ]);
        }

        return UserJiraMappings::create([
            'user_id'    => $userId
        ]);
    }


    /**
     * Taking the Laptop requested field from the issue array
     * @param array $jiraDetails   JIra issue details
     * @param string $fieldName  jira Custom field Name
     * @return string
     */
    public function getRequestedLaptopDetails($jiraDetails, $fieldName)
    {
        return $jiraDetails['issues'] ?
            ($jiraDetails['issues'][0]['fields'] ?
                is_array($jiraDetails['issues'][0]['fields'][$fieldName]) ?
                $jiraDetails['issues'][0]['fields'][$fieldName]['value']
                : $jiraDetails['issues'][0]['fields'][$fieldName]
                : "")
            : "";
    }
}
