<?php

namespace App\Services\NewHire;

use App\Models\Asset;
use App\Repositories\NewHire\NewHireForecastingRepository;

class NewHireEmployeesForecastingData
{
    public function __construct(NewHireForecastingRepository $newHireForecastingRepo)
    {
        $this->newHireForecastingRepo = $newHireForecastingRepo;
    }

    /**
     * It gets data from the database, filters it, and returns it
     */
    public function getNewhireForecastingData()
    {
        $newhireForecastingData = $this->newHireForecastingRepo->getNewHireForcastingData();
        $newhireForecastingData = $this->filterWithInputData($newhireForecastingData);
        $start = request('start');
        $limit = request('length');
        $count = $newhireForecastingData->count();
        if ($limit != -1) {
            $newhireForecastingData = $newhireForecastingData->offset($start)->limit($limit);
        }
        $newHires = $newhireForecastingData->get();


        return compact('newHires', 'count');
    }

    /**
     * It filters the data based on the input data
     *
     * @param newhireForecastingData This is the data that is being filtered.
     */
    public function filterWithInputData($newhireForecastingData)
    {
        $makeAndModel = isset(request('form')['make_and_model']) ? request('form')['make_and_model'] : '';
        $technicalSpec = isset(request('form')['technical_spec']) ? request('form')['technical_spec'] : '';
        $newhireForecastingData = $this->newHireForecastingRepo->filterWithHardwareKitData($newhireForecastingData, 'department_hardware_mappings.make_and_model_id', $makeAndModel);
        $newhireForecastingData = $this->newHireForecastingRepo->filterWithHardwareKitData($newhireForecastingData, 'department_hardware_mappings.technical_spec_id', $technicalSpec);
        return $newhireForecastingData;
    }

    /**
     * It takes an array of data, and returns an array of data
     *
     * @param newhireForecastingData This is the data that you're going to be using to build newhireforecastingdata.    *
     * @param data This is the data that will be used to populate the table.
     */
    public function formatData($newhireForecastingData, $data)
    {
        foreach ($newhireForecastingData as $newhireData) {
            $nestedData = $this->getNestedData($newhireData);
            $data[] = $nestedData;
        }
        // print_r($data);
        $result = $this->createNewhireForecastingCollection($data);
        return $result;
    }

    /**
     * It takes a collection of newhire data and returns a collection of nested data
     *
     * @param newhireData This is the data that is passed to the function.
     */
    public function getNestedData($newhireData)
    {
        $quantityProvided = Asset::where(['make_and_model_id' => $newhireData->make_and_model_id, 'technical_spec_id' => $newhireData->technical_spec_id])
            ->whereIn('user_id', $newhireData->newhireUsers->pluck('id')->toArray())->count();

        $quantityNeeded = $newhireData->newhireUsers->count() -  $quantityProvided;

        $data['hardware_standard']  = optional($newhireData->makeAndModel)->name;
        $data['technical_spec']  =  optional($newhireData->technicalSpec)->details;
        $data['quantity_needed']    = (int)$quantityNeeded;
        $data['techspec_total_value'] = (int)$newhireData->cost * $quantityNeeded;
        $data['quantity_available'] = $newhireData->totalassets;
        $data['purchase_indicator'] = $newhireData->totalassets < $quantityNeeded ? 'Yes' : 'No';

        return $data;
    }

    /**
     * It takes an array of arrays, groups them by a key, sums the values of the grouped arrays, and
     * returns a new array of arrays
     *
     * @param finalData This is the array of data that you want to group.
     */
    public function createNewhireForecastingCollection($finalData)
    {
        $finalDataCollection = collect($finalData);
        $purchaseIndicator = isset(request('form')['purchase_indicator']) ? request('form')['purchase_indicator'] : '';
        $result = $finalDataCollection->groupBy(function ($item, $key) {
            return $item['hardware_standard'] . $item['technical_spec'];
        });
        $groupwithcount = $result->map(function ($group) { //groups the department wise data to show in table
            return [
                'hardware_standard' => $group->first()['hardware_standard'],
                'technical_spec' => $group->first()['technical_spec'],
                'quantity_needed' => $group->sum('quantity_needed'),
                'techspec_avg_value' => $group->sum('quantity_needed') > 0 ? ("$ " . (number_format($group->sum('techspec_total_value') / $group->sum('quantity_needed')))) : 0,
                'quantity_available' => $group->first()['quantity_available'],
                'purchase_indicator' => $group->first()['quantity_available'] < $group->sum('quantity_needed') ? 'Yes' : 'No',
            ];
        });
        if ($purchaseIndicator) {
            $groupwithcount = $groupwithcount->where('purchase_indicator', $purchaseIndicator);
        }

        // dd($groupwithcount->values()->toArray());
        return $groupwithcount->values()->toArray();
    }
}
