<?php

namespace App\Services\NewHire;

use App\Models\EmployeeType;
use App\Models\Location;
use App\User;
use DB;
use App\Repositories\UserRepository;
use Facades\App\Services\JiraService;
use App\Models\AssetStatus;
use App\Models\MakeAndModel;
use App\Models\TechnicalSpecs;
use Carbon\Carbon;

class NewHireEmployeesData
{
    protected $userRepository;
    protected $assingStatusId;

    public function __construct(UserRepository $userRepository)
    {
        $this->userRepository = $userRepository;
        $this->assingStatusId = AssetStatus::where('slug', 'assigned')->first()->id;
    }

    /**
     * Performs filtr for the display based on filter inputs
     * @return [type]
     */
    public function filter()
    {

        $inputData = $this->getInputData();
        $users = $this->userRepository->getNewHires();
        $users = $this->userRepository->searchWithGeneralQueries($users, $inputData['employeeName']);
        $users = $this->userRepository->searchWithNumberOfAssets($users, $inputData['noOfAssets']);
        $users = $this->userRepository->searchUserWithWorkLocation($users, $inputData['workLocation']);
        $users = $this->userRepository->searchUserWithEmployeeType($users, $inputData['employeeType']);
        $users = $this->userRepository->searchNewhireUserWithFromDate($users, $inputData['dateFrom']);
        $users = $this->userRepository->searchUserWithToDate($users, $inputData['dateTo']);
        $users = $this->userRepository->searchUserWithDepartment($users, $inputData['department']);
        if ($inputData['fte'] && $inputData['fte'] == 'full_time') {
            $users = $this->userRepository->getFteUsers($users, $inputData['fte']);
        }
        if ($inputData['fte'] && $inputData['fte'] == 'ext') {
            $users = $this->userRepository->getExtUsers($users, $inputData['fte']);
        }
        $users = $users->orderBy('hire_date')
            ->orderBy('last_name')
            ->orderBy('first_name');

        $count = $users->count();
        $users = $this->getOutputData($users);

        return compact('users', 'count');
    }

    /**
     * Performs filetr for the export based on filter inputs
     * @return [type]
     */
    public function filterData()
    {
        $users = $this->userRepository->getNewHires();
        $inputData = $this->getExportInputData();
        $users = $this->userRepository->searchWithGeneralQueries($users, $inputData['employeeName']);
        $users = $this->userRepository->searchWithNumberOfAssets($users, $inputData['noOfAssets']);
        $users = $this->userRepository->searchUserWithWorkLocation($users, $inputData['workLocation']);
        $users = $this->userRepository->searchUserWithEmployeeType($users, $inputData['employeeType']);
        $users = $this->userRepository->searchNewhireUserWithFromDate($users, $inputData['dateFrom']);
        $users = $this->userRepository->searchUserWithToDate($users, $inputData['dateTo']);
        $users = $this->userRepository->searchUserWithDepartment($users, $inputData['department']);
        if ($inputData['fte'] && $inputData['fte'] == 'full_time') {
            $users = $this->userRepository->getFteUsers($users, $inputData['fte']);
        }
        if ($inputData['fte'] && $inputData['fte'] == 'ext') {
            $users = $this->userRepository->getExtUsers($users, $inputData['fte']);
        }
        $users = $users->orderBy('hire_date')
            ->orderBy('last_name')
            ->orderBy('first_name');
        return $users;
    }

    /**
     * making input array for data display
     * @return [type]
     */
    public function getInputData()
    {
        return [
            'employeeName'   => isset(request('form')['employee_name']) ? request('form')['employee_name'] : '',
            'noOfAssets'     => isset(request('form')['no_of_assets']) ? request('form')['no_of_assets'] : '',
            'workLocation'   => isset(request('form')['work_location']) ? request('form')['work_location'] : '',
            'employeeType'   => isset(request('form')['employee_type']) ? request('form')['employee_type'] : '',
            'dateFrom'       => isset(request('form')['date_from']) ? request('form')['date_from'] : Carbon::now()->addDay()->format(config('date.formats.read_date_format')),
            'dateTo'         => isset(request('form')['date_to']) ? request('form')['date_to'] : '',
            'jobFamily'      => isset(request('form')['job_family']) ? request('form')['job_family'] : '',
            'department'     => isset(request('form')['department']) ? request('form')['department'] : '',
            'fte'            => isset(request('form')['fte']) ? request('form')['fte'] : '',
        ];
    }

    /**
     * making input data array for export
     * @return [type]
     */
    public function getExportInputData()
    {
        return [
            'employeeName'   => request('employee_name') ? request('employee_name') : '',
            'noOfAssets'     => request('no_of_assets') != '' ? request('no_of_assets') : '',
            'workLocation'   => request('work_location') ? request('work_location') : '',
            'employeeType'   => request('employee_type') ? request('employee_type') : '',
            'dateFrom'       => request('date_from') ? request('date_from') : Carbon::now()->addDay()->format('m/d/Y'),
            'dateTo'         => request('date_to') ? request('date_to') : '',
            'jobFamily'      => request('job_family') ? request('job_family') : '',
            'department'     => request('department') ? request('department') : '',
            'fte'            => request('fte') ? request('fte') : '',
        ];
    }

    public function getOutputData($users)
    {
        $start = request('start');
        $limit = request('length');
        if ($limit != -1) {
            $users = $users->offset($start)
                ->limit($limit);
        }
        return $users->get();
    }

    /**
     * creates data for showing newhire users
     * @param mixed $users
     * @param mixed $start
     * @param mixed $data
     * 
     * @return [type]
     */
    public function getUserData($users, $start, $data)
    {
        $parentIndex = $start;

        foreach ($users as $key => $user) {
            $parentIndex++;
            $email = route('users.show', $user->id);

            $nestedData = $this->getNestedData($user, $parentIndex, $email);
            $data[] = $nestedData;
        }

        return $data;
    }

    /**
     * making the array for displaying new hire users
     * @param mixed $user
     * @param mixed $index
     * @param mixed $email
     * 
     * @return [type]
     */
    public function getNestedData($user, $index, $email)
    {
        // dd($user);
        // $history = $this->userRepository->getAssignedOrLoanedLatestHistory($user->id);
        $hardwareKits = $this->getDepartmentHardwareMappings($user);

        if (!empty($user->hire_date && $user->hire_date != '0000-00-00' && $user->hire_date != '11/30/-0001')) {
            $hireDate = $user->hire_date;
        } else {
            $hireDate = '';
        }

        if (!empty(optional($user->newUserAssetHistory)->created_at && optional($user->newUserAssetHistory)->created_at != '0000-00-00' && optional($user->newUserAssetHistory)->created_at != '11/30/-0001 12:00:00 AM')) {
            $modifiedDate = parse_date_from_db_datetime(optional($user->newUserAssetHistory)->getRaworiginal('created_at'));
        } else {
            $modifiedDate = '';
        }

        $nestedData['id'] = $index;
        $nestedData['first_name'] = $user->first_name;
        $nestedData['last_name'] = $user->last_name;
        $nestedData['email'] = "<a href=$email>$user->email</a>";
        $nestedData['title'] = optional($user->position)->name;
        $nestedData['employee_type'] = optional($user->employeeType)->name;
        $nestedData['start_date'] = $hireDate;
        $nestedData['department'] = optional($user->department)->name;
        $nestedData['location'] = $user->city;
        $nestedData['status'] = $user->status == 1 ? 'Active' : 'Terminated';
        $nestedData['modified_date'] = $modifiedDate;
        $nestedData['modified_by'] = optional(optional($user->newUserAssetHistory)->user)->userName;
        $nestedData['no_of_assets'] = $this->getAssetsButton($user);
        $nestedData['ticket_no'] = optional($user->userJiraMappings)->ticket_no;
        $nestedData['ticket_status'] = $user->userJiraMapping ? optional($user->userJiraMapping)->ticket_status : '';
        $nestedData['asset_requested'] = optional($user->userJiraMappings)->device_requested;
        $nestedData['tracking_number']  = $this->trackingNumberButton($user);
        $nestedData['shipment_status']  = $this->getShipmentStatus($user);
        $nestedData['asset_requested'] = $this->getAssetRequestedButton($hardwareKits);
        $nestedData['email_user'] = $this->createEmailButton($user);
        $nestedData['action_buttons'] = $this->getActionButtons($hardwareKits, $user);


        return $nestedData;
    }

    private function getActionButtons($hardwareKits, $user)
    {

        $actions = "";

        $actions .= $this->getAssetRequestedButton($hardwareKits);

        $actions .= $this->getAssignAssetButton($user);

        $actions .= $this->createEmailButton($user);

        return $actions;
    }

    public function trackingNumberButton($user)
    {
        $shipment = optional($user->assets)->first();
        $trackingNumber = $shipment ? optional($shipment->assetTracking)->tracking_number ?? '#' : "#";
        $dataTrackingNumber = $shipment ? optional($shipment->assetTracking)->tracking_number ?? '' : "";
        return "<a href='' class='btn asset-tracking-btn' data-toggle='modal' data-tracking-number='" . $dataTrackingNumber . "' data-user='" . $user->id . "'> " . $trackingNumber . " </a>";
    }

    public function getShipmentStatus($user)
    {
        $shipment = optional($user->assets)->first();
        return $shipment ? optional($shipment->assetTracking)->shipment_status : "";
    }

    public function getAssetRequestedButton($hardwareKits)
    {
        return "<a class='btn btn-link' data-toggle='modal' data-target='#HardwareChoiceModal' data-hardware-choices='" . json_encode($hardwareKits) . "' data-tooltip='tooltip' data-placement='left' title='Hardware Kit'><i class='icon icon-responsive'></i></a>";
    }

    /**
     * The view assets button
     * @param mixed $user
     * 
     * @return [type]
     */
    public function getAssetsButton($user)
    {
        $viewAssetUrl = route('viewAssets', ['id' => $user->id]);
        return "<a href='' data-action='" . $viewAssetUrl . "'  data-toggle='modal' data-asset-id='" . $user->id . "' data-target='#viewAssetModal'> " . optional($user->assets)->count() . " </a>";
    }

    /**
     * create an email button to sent email to new hire user about tracking details
     */
    public function createEmailButton($user)
    {
        $shipment = optional($user->assets)->first();
        $trackingNumber = $shipment ? optional($shipment->assetTracking)->tracking_number ?? '' : "";
        $assetsDetails = "";
        if ($user->assets) {
            $i = 1;
            foreach ($user->assets  as $key => $asset) {
                $assetsDetails .= "Laptop Asset #: " . $asset->serial_no . "    Hardware Standard: " . ($asset->makeAndModel ? $asset->makeAndModel->name : '') . "  \r";
            }
        }
        $subject = "Teqtivity IT - Asset(s) assigned with tracking #: " . $trackingNumber;
        $emailBody = "Hi " . $user->first_name . ' ' . $user->last_name . ",\r\r"
            . "Welcome to Teqtivity! Happy to have you onboard!\r\r"
            . "The following asset(s) have been assigned and shipped to you via the address you have provided!\r\r";
        $emailBody .= $assetsDetails;
        if ($trackingNumber != '') {
            $emailBody .= "Tracking Number #: " . $trackingNumber . "\r";
        }
        $emailBody .= "\rYour laptop password will be sent over to your Teqtivity Google account in the next few days. Please be on the lookout for your Teqtivity Google registration email and activate it within 48hours.\r\r";
        $emailBody .= "If you have any questions or concerns, feel free to reach out to the IT team via IT-desktop-support@teqtivity.com.";
        $emailBody .= "\r\rThank you\rTeqtivity IT";
        return  "<a class='btn btn-link' target='_blank' href='https://mail.google.com/mail/u/0/?fs=1&to=&su=" . urlencode($subject) . "&body=" . urlencode($emailBody) . "&tf=cm' data-tooltip='tooltip' data-placement='left' title='Email User'><i class='icon icon-email'></i></a>";
    }


    /**
     * Returns individual departments hardware kits
     * @param mixed $user
     * 
     * @return [type]
     */
    public function getDepartmentHardwareMappings($user)
    {
        $hardwareKits = $user->department ? $user->department->hardwarekits : [];
        $hardwareKitsArray = [];
        foreach ($hardwareKits as $row) {
            $makeAndModel = optional($row->makeAndModel)->name;
            $techSpec = optional($row->technicalSpec)->details;
            $hardwareKitsArray[] = $makeAndModel . ' - ' . $techSpec;
        }
        return $hardwareKitsArray;
    }

    /**
     * returns the data for exporting New hire users
     * @param mixed $user
     * @param mixed $index
     * 
     * @return [type]
     */
    public function getExportUserData($users, $start, $data)
    {
        $parentIndex = $start;
        foreach ($users as $key => $user) {
            $parentIndex++;
            $nestedData = $this->getExportNestedData($user, $parentIndex);
            $data[] = $nestedData;
        }
        return $data;
    }

    /**
     * creates the array for exporting New hire users
     * @param mixed $user
     * @param mixed $index
     * 
     * @return [type]
     */
    public function getExportNestedData($user, $index)
    {
        $history = $this->userRepository->getAssignedOrLoanedLatestHistory($user->user_id);
        $hardwareKits = $this->getDepartmentHardwareMappings($user);
        if (!empty($user->hire_date && $user->hire_date != '0000-00-00' && $user->hire_date != '11/30/-0001')) {
            $hireDate = $user->hire_date;
        } else {
            $hireDate = '';
        }

        if (!empty($user->modified_date && $user->modified_date != '0000-00-00' && $user->modified_date != '11/30/-0001 12:00:00 AM')) {
            $modifiedDate = parse_date_from_db_datetime($user->modified_date);
        } else {
            $modifiedDate = '';
        }

        $nestedData['Sl No'] = $index;
        $nestedData['First Name'] = disableCSVInjection($user->first_name);
        $nestedData['Last Name'] = disableCSVInjection($user->last_name);
        $nestedData['E-mail'] = disableCSVInjection($user->email);
        $nestedData['Title'] = disableCSVInjection(optional($user->position)->name);
        $nestedData['Employee Type'] = disableCSVInjection(optional($user->employeeType)->name);
        $nestedData['Start Date'] = $hireDate;
        $nestedData['Department'] = disableCSVInjection(optional($user->department)->name);
        $nestedData['Location'] = disableCSVInjection($user->city);
        $nestedData['Modified Date'] = $modifiedDate;
        $nestedData['Modified By'] = disableCSVInjection($history ? optional($history->user)->first_name . ' ' . optional($history->user)->last_name : '');
        $nestedData['No of Assets'] = optional($user->assets)->count();
        $nestedData['Ticket No'] = disableCSVInjection(optional($user->userJiraMappings)->ticket_no);
        $nestedData['Asset Requested'] = disableCSVInjection(implode(', ', $hardwareKits));
        $nestedData['Ticket Status'] = $user->userJiraMapping ? disableCSVInjection(optional($user->userJiraMapping)->ticket_status) : '';

        return $nestedData;
    }

    /**
     * Assign asset button for Nubers
     * @param $user      App\Models\Nuber;
     * @return string
     */
    public function getAssignAssetButton($user)
    {
        /**
         * If new hire user already have a assinged/loaned laptop then disable the assingn asset button
         * If new hire user doesnt have assinned laptop/loaned then enable the assign asset button
         */
        $assignedStatus = User::userHasAssetAssignedOrLoaned($user->id);
        $assignAssetLinkClass = $assignedStatus > 0 ? 'disabled' : 'assign-asset';

        return "<a class='btn btn-link $assignAssetLinkClass' data-user='" . $user->id . "' data-ticket='" . optional($user->userJiraMappings)->ticket_no . "' data-tooltip='tooltip' data-placement='left' title='Assign Asset'><i class='icon icon-explore-user'></i></a>";
    }
}
