<?php

namespace App\Services\Location;

use App\Http\Responses\ReportOutputData;
use App\Models\Asset;

class LocationAssetData
{

    public function __construct(protected  ReportOutputData $reportOutputData)
    {
    }

    /** function fiters assets of the selected location and returns paginated data
     * @return Assets
     */
    public function locationAssetsFilter()
    {

        $assets = Asset::with(
            'assetType:id,name',
            'makeAndModel.manufacturer',
            'technicalSpec',
            'assetStatus',
            'airwatch:id,asset_id,last_seen',
            'chromebook:id,asset_id,last_sync',
            'intune:id,asset_id,checkin_date',
            'jamf:id,asset_id,checkin_date',
            'kandjiDevices:id,asset_id,last_checkin',
            'mobileIron:id,asset_id,last_checkin'
        )->where('location_id', request('form')['location']);
        $searchText   = isset(request('form')['filter']) ? request('form')['filter'] : '';

        if ($searchText) {
            $assets = $assets->where(function ($query) use ($searchText) {
                $query->where('serial_no', 'like', '%' . $searchText . '%')
                    ->orWhere('asset_tag', 'like', '%' . $searchText . '%');
            });
        }

        $count = $assets->count();

        $assets = $this->reportOutputData->getOutputData($assets);

        return compact('assets', 'count');
    }

    /**
     * Gets the paginated data of assets in the location
     * @param mixed $assets
     * @param mixed $start
     * @param mixed $data
     * 
     * @return [type]
     */
    public function getLocationAssetData($assets, $start, $data)
    {
        $parentIndex = $start;

        foreach ($assets as $key => $asset) {
            $parentId = $asset->id;

            $parentIndex++;
            $name = route('assets.show', $asset->id);

            $nestedData = $this->getNestedLocationAssetData($asset, $parentIndex, '', '', $name);

            $data[] = $nestedData;
        }

        return $data;
    }

    /**
     * Makes array of individual rows for location assets data.
     * @param mixed $asset
     * @param mixed $index
     * @param mixed $last
     * @param mixed $parent
     * @param mixed $name
     * 
     * @return [type]
     */
    public function getNestedLocationAssetData($asset, $index, $last, $parent, $name)
    {
        $manufacturer = $asset->makeAndModel->manufacturer->name ?? '';
        $makeAndModelName = $asset->makeAndModel->name ?? '';
        $nestedData['id']           = $index;
        $nestedData['asset_type']    = $asset->assetType->name ?? '';
        $nestedData['hardware']     = $manufacturer . ' - ' . $makeAndModelName;
        $nestedData['technical_spec']         = $asset->technicalSpec->details ?? '';
        $nestedData['asset_tag']      = "<a href=$name>$asset->asset_tag</a>";
        $nestedData['serial_no']        = "<a href=$name>$asset->serial_no</a>";
        $nestedData['status']     = $asset->assetStatus->name ?? '';
        $nestedData['age']      = $asset->assetAge;
        $nestedData['last']       = ' ';
        $nestedData['last_seen']       = $asset->last_seen;
        return $nestedData;
    }
}
