<?php

namespace App\Services\JiraDescriptions;

use App\Models\Asset;
use App\User;
use Illuminate\Support\Facades\Auth;
use Facades\App\Services\AssetHistory as AssetHistoryService;
use App\Http\Traits\JiraPluginTrait;

class DescriptionForUpdateAssignee implements JiraDescription
{
  use JiraPluginTrait;

  function description($status, $data, $asset, $comments = null)
  {

    $commentstext = '';

    $oldName = AssetHistoryService::getOldLocationOrUsername($asset);
    $oldUserName = ($oldName != null) ? (' from ' . $oldName) : " ";
    $touser = User::where('id', $data['user_id'])->first();
    $newUserName = ($touser != null) ? (' to ' . $touser->first_name . ' ' . $touser->last_name) : " ";

    $user = $this->getAuthenticatedUser();

    return __('jira.updateAssignee', [
      'assetname' => $asset->serial_no,
      'assetid' => $asset->id,
      'oldusername' =>  $oldUserName,
      'newusername' => $newUserName,
      'commenttext' => $commentstext,
      'username'  => trim($user->first_name . ' ' . $user->last_name),
      'useremail' => trim($user->email),
    ]);
  }
}
