<?php

namespace App\Services\JiraDescriptions;

use App\Http\Traits\JiraPluginTrait;

class DescriptionForStolenLost implements JiraDescription
{
    use JiraPluginTrait;

    /**
     * Generates a description for the stolen/lost status in Jira.
     *
     * @param string $status The new status of the asset.
     * @param array $data Additional data for the description.
     * @param \App\Models\Asset $asset The asset being described.
     * @param string|null $comments Optional comments for the description.
     *
     * @return string The formatted description string.
     */
    function description($status, $data, $asset, $comments = null)
    {

        $commentstext = formatTicketComment($comments);
        $user = $this->getAuthenticatedUser();

        $stolenOrLostDateText = $data['lost_date'] ? " with stolen/lost date updated to {$data['lost_date']}," : "";

        return __('jira.StolenLost', [
            'assetname' => $asset->serial_no,
            'assetid' => $asset->id,
            'oldasset_status' => $asset->assetStatus?->name,
            'newstatus' => $status,
            'commenttext' => $commentstext,
            'stolenOrLostDateText' => $stolenOrLostDateText,
            'username'  => $user->first_name . ' ' . $user->last_name,
            'useremail' => $user->email,
        ]);
    }
}
