<?php

namespace App\Services\JiraDescriptions;

use Facades\App\Services\AssetHistory as AssetHistoryService;
use App\Http\Traits\JiraPluginTrait;

class DescriptionForRetainHold implements JiraDescription
{
	use JiraPluginTrait;

	/**
	 * Generate the Jira description for a retain hold asset.
	 *
	 * @param string $status The new status of the asset.
	 * @param array $data Additional data including location and retention date.
	 * @param \App\Models\Asset $asset The asset object containing current asset details.
	 * @param string|null $comments Optional comments regarding the asset.
	 *
	 * @return string The formatted description string.
	 */
	function description($status, $data, $asset, $comments = null)
	{

		$tolocation = AssetHistoryService::getToLocationOrUsername($data);
		$commentstext = formatTicketComment($comments);
		$oldUserName = AssetHistoryService::getOldLocationOrUsername($asset);
		$oldUserName = ($oldUserName != null) ? (' from ' . $oldUserName) : " ";
		$user = $this->getAuthenticatedUser();

		return  __('jira.RetainHold', [
			'assetname' => $asset->serial_no,
			'assetid' => $asset->id,
			'oldasset_status' => optional($asset->assetStatus)->name,
			'newstatus' => $status,
			'oldusername' => $oldUserName,
			'roomname' => $tolocation,
			'retention_date' => $data['loaner_retention_date'],
			'commenttext' => $commentstext,
			'username'  => trim($user->first_name . ' ' . $user->last_name),
			'useremail' => trim($user->email),

		]);
	}
}
