<?php

namespace App\Services\JiraDescriptions;

use App\Http\Traits\JiraPluginTrait;
use App\Models\Vendor;

class DescriptionForRMAReturned  implements JiraDescription
{
    use JiraPluginTrait;

    /**
     * Jira description for RMA Returned action.
     * @param string $status new status of the asset
     * @param array $data additional data for the action
     * @param \App\Models\Asset $asset asset being processed
     * @param string|null $comments comments for the action
     * @return string Jira description string
     */
    function description($status, $data, $asset, $comments = null)
    {

        $commentstext = formatTicketComment($comments);
        $user = $this->getAuthenticatedUser();
        return __('jira.RMAReturned', [
            'assetname' => $asset->serial_no,
            'assetid' => $asset->id,
            'oldasset_status' => optional($asset->assetStatus)->name,
            'newstatus' => $status,
            'vendor' => optional(Vendor::find($data['vendor_id'] ?? 0))->name,
            'commenttext' => $commentstext,
            'username'  => trim($user->first_name . ' ' . $user->last_name),
            'useremail' => trim($user->email),
        ]);
    }
}
