<?php

namespace App\Services\JiraDescriptions;

use Facades\App\Services\AssetHistory as AssetHistoryService;
use App\Http\Traits\JiraPluginTrait;

class DescriptionForLoaned implements JiraDescription
{
	use JiraPluginTrait;

	/**
	 * Generate the Jira description for a loaned asset.
	 *
	 * @param string $status
	 * @param array $data
	 * @param Asset $asset
	 * @param string|null $comments
	 * @return string
	 */
	function description($status, $data, $asset, $comments = null)
	{

		$tousername = AssetHistoryService::getToLocationOrUsername($data);
		$commentstext = formatTicketComment($comments);
		$oldUserName = AssetHistoryService::getOldLocationOrUsername($asset);
		$oldUserName = ($oldUserName != null) ? (' from ' . $oldUserName) : " ";
		$user = $this->getAuthenticatedUser();

		return  __('jira.Loaned', [
			'assetname' => $asset->serial_no,
			'assetid' => $asset->id,
			'oldasset_status' => optional($asset->assetStatus)->name,
			'newstatus' => $status,
			'oldusername' => $oldUserName,
			'roomname' => $tousername,
			'loanerdate' => $data['loaner_return_date'],
			'commenttext' => $commentstext,
			'username'  => trim($user->first_name . ' ' . $user->last_name),
			'useremail' => trim($user->email),

		]);
	}
}
